/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.content.advancement.SpellPredicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class SpellDiscoveryTrigger
implements CriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = WizardryMainMod.location("discover_spell");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(@NotNull PlayerAdvancements advancements, @NotNull CriterionTrigger.Listener<TriggerInstance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void m_6468_(@NotNull PlayerAdvancements advancements, @NotNull CriterionTrigger.Listener<TriggerInstance> listener) {
        Listeners li = this.listeners.get(advancements);
        if (li == null) {
            return;
        }
        li.remove(listener);
        if (li.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void m_5656_(@NotNull PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    @NotNull
    public TriggerInstance createInstance(@NotNull JsonObject json, @NotNull DeserializationContext context) {
        String s = GsonHelper.m_13906_((JsonObject)json, (String)"source");
        EBDiscoverSpellEvent.Source source = EBDiscoverSpellEvent.Source.byName(s);
        if (source == null) {
            throw new JsonSyntaxException("No such spell discovery source: " + s);
        }
        return new TriggerInstance(SpellPredicate.deserialize(json.get("spell")), source, json, context);
    }

    public void trigger(ServerPlayer player, Spell spell, EBDiscoverSpellEvent.Source source) {
        Optional.ofNullable(this.listeners.get(player.m_8960_())).ifPresent(listeners -> listeners.trigger(spell, source));
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<TriggerInstance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<TriggerInstance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<TriggerInstance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Spell spell, EBDiscoverSpellEvent.Source source) {
            List<CriterionTrigger.Listener> list = this.listeners.stream().filter(li -> ((TriggerInstance)li.m_13685_()).test(spell, source)).toList();
            list.forEach(li -> li.m_13686_(this.playerAdvancements));
        }
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final SpellPredicate spell;
        private final EBDiscoverSpellEvent.Source source;

        public TriggerInstance(SpellPredicate spell, EBDiscoverSpellEvent.Source source, JsonObject json, DeserializationContext context) {
            super(ID, EntityPredicate.m_285855_((JsonObject)json, (String)"player", (DeserializationContext)context));
            this.spell = spell;
            this.source = source;
        }

        public TriggerInstance(SpellPredicate spell, EBDiscoverSpellEvent.Source source) {
            super(ID, ContextAwarePredicate.f_285567_);
            this.spell = spell;
            this.source = source;
        }

        public static TriggerInstance discoverSpell(EBDiscoverSpellEvent.Source source) {
            return new TriggerInstance(SpellPredicate.any(), source);
        }

        public boolean test(Spell spell, EBDiscoverSpellEvent.Source source) {
            return this.spell.test(spell) && source == this.source;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.addProperty("source", this.source.name().toLowerCase());
            JsonElement spellJson = this.spell.serialize();
            if (spellJson != null) {
                jsonobject.add("spell", spellJson);
            }
            return jsonobject;
        }
    }
}

