/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.advancement;

import com.binaris.wizardry.WizardryMainMod;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WizardryContainerTrigger
implements CriterionTrigger<TriggerInstance> {
    private final ResourceLocation ID;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public WizardryContainerTrigger(String name) {
        this.ID = WizardryMainMod.location(name);
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.ID;
    }

    public void m_6467_(@NotNull PlayerAdvancements advancements, @NotNull CriterionTrigger.Listener<TriggerInstance> listener) {
        this.listeners.computeIfAbsent(advancements, Listeners::new).add(listener);
    }

    public void m_6468_(@NotNull PlayerAdvancements advancements, @NotNull CriterionTrigger.Listener<TriggerInstance> listener) {
        Listeners li = this.listeners.get(advancements);
        if (li == null) {
            return;
        }
        li.remove(listener);
        if (li.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void m_5656_(@NotNull PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    @NotNull
    public TriggerInstance createInstance(@NotNull JsonObject json, @NotNull DeserializationContext context) {
        return new TriggerInstance(this.ID, ItemPredicate.m_45051_((JsonElement)json.get("item")), json, context);
    }

    public void trigger(ServerPlayer player, ItemStack stack) {
        Optional.ofNullable(this.listeners.get(player.m_8960_())).ifPresent(li -> li.trigger(stack));
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<TriggerInstance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<TriggerInstance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<TriggerInstance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack stack) {
            List<CriterionTrigger.Listener> list = this.listeners.stream().filter(li -> ((TriggerInstance)li.m_13685_()).test(stack)).toList();
            list.forEach(li -> li.m_13686_(this.playerAdvancements));
        }
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;

        public TriggerInstance(ResourceLocation criterionIn, ItemPredicate item, JsonObject json, DeserializationContext context) {
            super(criterionIn, EntityPredicate.m_285855_((JsonObject)json, (String)"player", (DeserializationContext)context));
            this.item = item;
        }

        public TriggerInstance(ResourceLocation criterionIn, ItemPredicate item) {
            super(criterionIn, ContextAwarePredicate.f_285567_);
            this.item = item;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.add("item", this.item.m_45048_());
            return jsonobject;
        }

        public boolean test(ItemStack stack) {
            return this.item.m_45049_(stack);
        }
    }
}

