/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.block;

import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.block.WallReceptacleBlock;
import com.binaris.wizardry.content.blockentity.ImbuementAltarBlockEntity;
import com.binaris.wizardry.content.item.RandomSpellBookItem;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBBlocks;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImbuementAltarBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static final VoxelShape AABB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);

    public ImbuementAltarBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(-1.0f, 6000000.0f).m_60953_(state -> 1));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type, BlockEntityType<ImbuementAltarBlockEntity> entityType) {
        return ImbuementAltarBlock.m_152132_(type, type, ImbuementAltarBlockEntity::update);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ImbuementAltarBlockEntity entity;
        block13: {
            block12: {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof ImbuementAltarBlockEntity)) break block12;
                entity = (ImbuementAltarBlockEntity)blockEntity;
                if (!player.m_6144_()) break block13;
            }
            return InteractionResult.FAIL;
        }
        ItemStack currentStack = entity.getStack();
        ItemStack toInsert = player.m_21120_(hand);
        if (currentStack.m_41619_()) {
            ItemStack stack = toInsert.m_41777_();
            stack.m_41764_(1);
            entity.setStack(stack, true);
            entity.setLastUser(player);
            if (!player.m_7500_()) {
                toInsert.m_41774_(1);
            }
        } else {
            if (currentStack.m_41720_() instanceof RandomSpellBookItem) {
                RandomSpellBookItem.create(level, player, currentStack);
            } else if (toInsert.m_41619_()) {
                player.m_36356_(currentStack);
            } else if (!player.m_36356_(currentStack)) {
                player.m_36176_(currentStack, false);
            }
            entity.setStack(ItemStack.f_41583_, false);
            entity.setLastUser(null);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity tileEntity;
        boolean shouldBeActive = Arrays.stream(BlockUtil.getHorizontals()).allMatch(s -> level.m_8055_(pos.m_121945_(s)).m_60734_() == EBBlocks.WALL_RECEPTACLE.get() && level.m_8055_(pos.m_121945_(s)).m_61143_((Property)WallReceptacleBlock.FACING) == s);
        if ((Boolean)level.m_8055_(pos).m_61143_((Property)ACTIVE) != shouldBeActive) {
            ImbuementAltarBlockEntity e;
            BlockEntity te = level.m_7702_(pos);
            ItemStack stack = ItemStack.f_41583_;
            if (te instanceof ImbuementAltarBlockEntity) {
                e = (ImbuementAltarBlockEntity)te;
                stack = e.getStack();
            }
            level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive)));
            te = level.m_7702_(pos);
            if (te instanceof ImbuementAltarBlockEntity) {
                e = (ImbuementAltarBlockEntity)te;
                e.setStack(stack, true);
            }
            level.m_7726_().m_7827_().m_7174_(pos);
        }
        if ((tileEntity = level.m_7702_(pos)) instanceof ImbuementAltarBlockEntity) {
            ImbuementAltarBlockEntity e = (ImbuementAltarBlockEntity)tileEntity;
            e.checkRecipe();
        }
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public int m_7753_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? super.m_7753_(state, level, pos) : 0;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return ImbuementAltarBlock.createTicker(level, type, EBBlockEntities.IMBUEMENT_ALTAR.get());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ImbuementAltarBlockEntity(pos, state);
    }
}

