/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.block;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.blockentity.ReceptacleBlockEntity;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReceptacleBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public ReceptacleBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_60978_(0.5f).m_60977_().m_60953_(b -> 1).m_60918_(SoundType.f_56742_));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AABB;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return ReceptacleBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        IElementValue value;
        Item item;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ReceptacleBlockEntity)) {
            return InteractionResult.PASS;
        }
        ReceptacleBlockEntity blockEntity2 = (ReceptacleBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        ItemStack stack = blockEntity2.getStack();
        if (stack.m_41619_() && !heldItem.m_41619_() && (item = heldItem.m_41720_()) instanceof IElementValue && (value = (IElementValue)item).validForReceptacle()) {
            ItemStack receptacleItem = player.m_150110_().f_35937_ ? heldItem.m_41777_() : heldItem;
            blockEntity2.setStack(receptacleItem.m_41620_(1));
        }
        if (!stack.m_41619_() && !player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
        level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), EBSounds.BLOCK_RECEPTACLE_IGNITE.get(), SoundSource.BLOCKS, 0.7f, 0.7f, false);
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        ReceptacleBlockEntity entity;
        ItemStack stack;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReceptacleBlockEntity && !(stack = (entity = (ReceptacleBlockEntity)blockEntity).getStack()).m_41619_()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_214162_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ReceptacleBlockEntity)) {
            return;
        }
        ReceptacleBlockEntity entity = (ReceptacleBlockEntity)blockEntity;
        Element element = entity.getElement();
        if (element == null) {
            return;
        }
        Vec3 centre = GeometryUtil.getCentre(pos);
        int[] colors = element.getColors();
        ParticleBuilder.create(EBParticles.FLASH).pos(centre).scale(0.35f).time(48).color(colors[0]).spawn(level);
        double r = 0.12;
        for (int i = 0; i < 3; ++i) {
            double x = r * (random.m_188500_() * 2.0 - 1.0);
            double y = r * (random.m_188500_() * 2.0 - 1.0);
            double z = r * (random.m_188500_() * 2.0 - 1.0);
            ParticleBuilder.create(EBParticles.DUST).pos(centre.f_82479_ + x, centre.f_82480_ + y, centre.f_82481_ + z).velocity(x * -0.03, 0.02, z * -0.03).time(24 + random.m_188503_(8)).color(colors[1]).fade(colors[2]).spawn(level);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ReceptacleBlockEntity(pos, state);
    }

    public int m_7753_(@NotNull BlockState state, BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ReceptacleBlockEntity) {
            ReceptacleBlockEntity blockEntity = (ReceptacleBlockEntity)entity;
            Element element = blockEntity.getElement();
            return element == null ? 0 : super.m_7753_(state, level, pos);
        }
        return 0;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ReceptacleBlockEntity) {
            ReceptacleBlockEntity blockEntity = (ReceptacleBlockEntity)entity;
            Element element = blockEntity.getElement();
            return element == null ? 0 : Services.REGISTRY_UTIL.getElements().stream().toList().indexOf(element) + 1;
        }
        return super.m_6782_(state, level, pos);
    }
}

