/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.block;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.block.ImbuementAltarBlock;
import com.binaris.wizardry.content.block.ReceptacleBlock;
import com.binaris.wizardry.content.blockentity.ReceptacleBlockEntity;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WallReceptacleBlock
extends ReceptacleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final double WALL_PARTICLE_OFFSET = 0.1875;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallReceptacleBlock() {
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape getShape(BlockState state) {
        return AABBS.get(state.m_61143_((Property)FACING));
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return WallReceptacleBlock.getShape(state);
    }

    @Override
    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60734_() instanceof ImbuementAltarBlock) {
            return direction.m_122434_().m_122479_();
        }
        return blockstate.m_60783_((BlockGetter)level, blockpos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level levelreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @Override
    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Override
    public void m_214162_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ReceptacleBlockEntity)) {
            return;
        }
        ReceptacleBlockEntity entity = (ReceptacleBlockEntity)blockEntity;
        Element element = entity.getElement();
        if (element == null) {
            return;
        }
        Direction facing = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        Vec3 centre = GeometryUtil.getCentre(pos);
        centre = centre.m_82549_(new Vec3(facing.m_253071_()).m_82490_(0.1875)).m_82520_(0.0, 0.125, 0.0);
        int[] colors = element.getColors();
        ParticleBuilder.create(EBParticles.FLASH).pos(centre).scale(0.35f).time(48).color(colors[0]).spawn(level);
        double r = 0.12;
        for (int i = 0; i < 3; ++i) {
            double x = r * (random.m_188500_() * 2.0 - 1.0);
            double y = r * (random.m_188500_() * 2.0 - 1.0);
            double z = r * (random.m_188500_() * 2.0 - 1.0);
            ParticleBuilder.create(EBParticles.DUST).pos(centre.f_82479_ + x, centre.f_82480_ + y, centre.f_82481_ + z).velocity(x * -0.03, 0.02, z * -0.03).time(24 + random.m_188503_(8)).color(colors[1]).fade(colors[2]).spawn(level);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

