/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.item.CrystalItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcaneWorkbenchBlockEntity
extends BaseContainerBlockEntity {
    public float timer = 0.0f;
    public float rot;
    public float oRot;
    public float tRot;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)11, (Object)ItemStack.f_41583_);

    public ArcaneWorkbenchBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EBBlockEntities.ARCANE_WORKBENCH.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ArcaneWorkbenchBlockEntity entity) {
        ItemStack stack = entity.m_8020_(9);
        Item item = stack.m_41720_();
        if (item instanceof IManaStoringItem) {
            IManaStoringItem manaItem = (IManaStoringItem)item;
            if (!level.f_46443_ && !manaItem.isManaFull(stack) && level.m_46467_() % 50L == 0L) {
                manaItem.rechargeMana(stack, WandHelper.getUpgradeLevel(stack, EBItems.CONDENSER_UPGRADE.get()));
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ArcaneWorkbenchBlockEntity entity) {
        float rotDiff;
        if (!level.f_46443_) {
            return;
        }
        entity.timer += 1.0f;
        entity.oRot = entity.rot;
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double dx = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double dz = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
            entity.tRot = (float)Math.atan2(dz, dx);
        } else {
            entity.tRot += 0.02f;
        }
        while (entity.rot >= (float)Math.PI) {
            entity.rot -= (float)Math.PI * 2;
        }
        while (entity.rot < (float)(-Math.PI)) {
            entity.rot += (float)Math.PI * 2;
        }
        while (entity.tRot >= (float)Math.PI) {
            entity.tRot -= (float)Math.PI * 2;
        }
        while (entity.tRot < (float)(-Math.PI)) {
            entity.tRot += (float)Math.PI * 2;
        }
        for (rotDiff = entity.tRot - entity.rot; rotDiff >= (float)Math.PI; rotDiff -= (float)Math.PI * 2) {
        }
        while (rotDiff < (float)(-Math.PI)) {
            rotDiff += (float)Math.PI * 2;
        }
        entity.rot += rotDiff * 0.4f;
    }

    public void sync() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.sync();
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
        this.sync();
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.inventory, (int)slot);
        this.sync();
        return stack;
    }

    public boolean m_8077_() {
        return false;
    }

    public boolean m_6542_(@NotNull Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public boolean m_7013_(int slotNumber, @NotNull ItemStack itemstack) {
        if (itemstack == ItemStack.f_41583_) {
            return true;
        }
        this.m_6596_();
        if (slotNumber >= 0 && slotNumber < 8) {
            if (!(itemstack.m_41720_() instanceof SpellBookItem)) {
                return false;
            }
            ItemStack centreStack = this.m_8020_(9);
            Item item = centreStack.m_41720_();
            if (item instanceof IWorkbenchItem) {
                IWorkbenchItem workbenchItem = (IWorkbenchItem)item;
                int spellSlots = workbenchItem.getSpellSlotCount(centreStack);
                return slotNumber < spellSlots;
            }
            return false;
        }
        if (slotNumber == 8) {
            return itemstack.m_41720_() instanceof CrystalItem;
        }
        if (slotNumber == 9) {
            return itemstack.m_41720_() instanceof IWorkbenchItem;
        }
        if (slotNumber == 10) {
            HashSet<Item> upgrades = new HashSet<Item>(WandUpgrades.getSpecialUpgrades());
            upgrades.add(EBItems.ARCANE_TOME.get());
            upgrades.add(EBItems.RESPLENDENT_THREAD.get());
            upgrades.add(EBItems.CRYSTAL_SILVER_PLATING.get());
            upgrades.add(EBItems.ETHEREAL_CRYSTAL_WEAVE.get());
            return upgrades.contains(itemstack.m_41720_());
        }
        return true;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (this.inventory == null) {
            this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new ArcaneWorkbenchMenu(containerId, inventory, (Container)this);
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.%s.arcane_workbench".formatted("ebwizardry"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

