/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.blockentity.ReceptacleBlockEntity;
import com.binaris.wizardry.content.recipe.ImbuementAltarRecipe;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBRecipeTypes;
import com.binaris.wizardry.setup.registries.EBSounds;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImbuementAltarBlockEntity
extends BlockEntity {
    private static final int IMBUEMENT_DURATION = 140;
    private ItemStack stack = ItemStack.f_41583_;
    private int imbuementTimer;
    private Player lastUser;
    private UUID lastUserUUID;
    @Nullable
    private Element element;

    public ImbuementAltarBlockEntity(BlockPos pos, BlockState blockState) {
        super(EBBlockEntities.IMBUEMENT_ALTAR.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void update(Level level, BlockPos pos, BlockState state, T entity) {
        if (!(entity instanceof ImbuementAltarBlockEntity)) {
            return;
        }
        ImbuementAltarBlockEntity altar = (ImbuementAltarBlockEntity)entity;
        if (altar.getLastUserUUID() != null && altar.getLastUser() == null) {
            altar.lastUser = level.m_46003_(altar.lastUserUUID);
        }
        if (altar.imbuementTimer <= 0) {
            return;
        }
        if (altar.imbuementTimer == 1) {
            level.m_5594_(altar.lastUser, pos, EBSounds.BLOCK_IMBUEMENT_ALTAR_IMBUE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (altar.imbuementTimer++ >= 140) {
            altar.craftRecipe();
            Player player = altar.lastUser;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EBAdvancementTriggers.IMBUEMENT_ALTAR.trigger(serverPlayer, altar.stack);
            }
        }
    }

    private static ItemStack[] getReceptacleItems(Level level, BlockPos pos) {
        ItemStack[] items = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            BlockEntity te = level.m_7702_(pos.m_121945_(BlockUtil.getHorizontals()[i]));
            if (te instanceof ReceptacleBlockEntity) {
                ReceptacleBlockEntity e = (ReceptacleBlockEntity)te;
                items[i] = e.getStack();
                continue;
            }
            items[i] = null;
        }
        return items;
    }

    public void checkRecipe() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.stack.m_41619_()) {
            this.imbuementTimer = 0;
            return;
        }
        ItemStack[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.f_58857_, this.f_58858_);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.imbuementTimer = 0;
            return;
        }
        ImbuementAltarRecipe recipe = this.f_58857_.m_7465_().m_44013_(EBRecipeTypes.IMBUEMENT_ALTAR).stream().filter(r -> r instanceof ImbuementAltarRecipe).filter(r -> r.matches(this.stack, receptacleItems)).findFirst().orElse(null);
        if (recipe != null && this.imbuementTimer == 0) {
            this.imbuementTimer = 1;
            this.selectElement();
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        } else if (recipe == null) {
            this.imbuementTimer = 0;
        }
    }

    private void craftRecipe() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.f_58857_, this.f_58858_);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.imbuementTimer = 0;
            return;
        }
        ImbuementAltarRecipe recipe = this.f_58857_.m_7465_().m_44013_(EBRecipeTypes.IMBUEMENT_ALTAR).stream().filter(r -> r instanceof ImbuementAltarRecipe).filter(r -> r.matches(this.stack, receptacleItems)).findFirst().orElse(null);
        if (recipe != null) {
            int i;
            ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
            this.stack.m_41774_(1);
            for (i = 0; i < 4; ++i) {
                receptacleItems[i].m_41774_(1);
            }
            for (i = 0; i < 4; ++i) {
                BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(BlockUtil.getHorizontals()[i]));
                if (!(entity instanceof ReceptacleBlockEntity)) continue;
                ReceptacleBlockEntity e = (ReceptacleBlockEntity)entity;
                e.setStack(ItemStack.f_41583_);
                this.f_58857_.m_7260_(e.m_58899_(), e.m_58900_(), e.m_58900_(), 3);
            }
            this.setStack(result, false);
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, EBSounds.BLOCK_IMBUEMENT_ALTAR_IMBUE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        this.imbuementTimer = 0;
        this.m_6596_();
    }

    private void selectElement() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack[] receptacleItems = ImbuementAltarBlockEntity.getReceptacleItems(this.f_58857_, this.f_58858_);
        if (Arrays.stream(receptacleItems).anyMatch(Objects::isNull)) {
            this.element = null;
            return;
        }
        ItemStack item = receptacleItems[this.f_58857_.f_46441_.m_188503_(receptacleItems.length)];
        Item item2 = item.m_41720_();
        if (item2 instanceof IElementValue) {
            IElementValue receptacleItem = (IElementValue)item2;
            this.element = receptacleItem.getElement();
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag itemTag = new CompoundTag();
        this.stack.m_41739_(itemTag);
        nbt.m_128365_("item", (Tag)itemTag);
        nbt.m_128405_("imbuementTimer", this.imbuementTimer);
        if (this.element != null) {
            nbt.m_128359_("element", Services.REGISTRY_UTIL.getElement(this.element).toString());
        }
        if (this.lastUser != null) {
            nbt.m_128362_("lastUser", this.lastUser.m_20148_());
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag itemTag = nbt.m_128469_("item");
        this.stack = ItemStack.m_41712_((CompoundTag)itemTag);
        this.imbuementTimer = nbt.m_128451_("imbuementTimer");
        if (nbt.m_128441_("element")) {
            this.element = Services.REGISTRY_UTIL.getElement(ResourceLocation.m_135820_((String)nbt.m_128461_("element")));
        }
        if (nbt.m_128403_("lastUser")) {
            this.lastUserUUID = nbt.m_128342_("lastUser");
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public float getImbuementProgress() {
        return (float)this.imbuementTimer / 140.0f;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Player getLastUser() {
        return this.lastUser;
    }

    public void setLastUser(Player player) {
        this.lastUser = player;
        if (player != null) {
            this.lastUserUUID = player.m_20148_();
        }
    }

    public UUID getLastUserUUID() {
        return this.lastUserUUID;
    }

    @Nullable
    public Element getElement() {
        return this.element;
    }

    public void setStack(ItemStack stack, boolean shouldCheckRecipe) {
        this.stack = stack;
        if (shouldCheckRecipe) {
            this.checkRecipe();
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

