/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.blockentity;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.block.RunestonePedestalBlock;
import com.binaris.wizardry.content.entity.living.EvilWizard;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.mixin.accessor.RCBEAccessor;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBLootTables;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunestonePedestalBlockEntity
extends BlockEntity {
    private static final double ACTIVATION_RADIUS = 7.0;
    private static final int WIZARD_SPAWN_COUNT = 3;
    private static final int WIZARD_SPAWN_RADIUS = 5;
    private static final int REGENERATION_DELAY_TICKS = 72000;
    private final List<UUID> spawnedWizards = new ArrayList<UUID>();
    private final List<UUID> playersInContainment = new ArrayList<UUID>();
    @Nullable
    private BlockPos linkedPos;
    private boolean natural;
    private boolean activated;
    private boolean conquered;
    private long regenerationTime;

    public RunestonePedestalBlockEntity(BlockPos pos, BlockState blockState) {
        super(EBBlockEntities.RUNESTONE_PEDESTAL.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        RunestonePedestalBlockEntity pedestal;
        block11: {
            block10: {
                if (!(entity instanceof RunestonePedestalBlockEntity)) break block10;
                pedestal = (RunestonePedestalBlockEntity)entity;
                if (level != null && !level.f_46443_) break block11;
            }
            return;
        }
        if (pedestal.conquered && EBConfig.shrineRegenerationEnabled && pedestal.regenerationTime > 0L && level.m_46467_() >= pedestal.regenerationTime) {
            RunestonePedestalBlockEntity.regenerate(pedestal, pos);
            return;
        }
        if (!pedestal.natural) {
            level.m_46747_(pos);
            return;
        }
        if (pedestal.linkedPos == null) {
            pedestal.tryLinkContainer(pos);
            if (!pedestal.natural) {
                return;
            }
        }
        long gameTime = level.m_46467_();
        if (!pedestal.activated && gameTime % 20L == 0L) {
            pedestal.checkEvent(pos);
        }
        if (pedestal.activated) {
            pedestal.containmentEffect();
        }
        if (pedestal.activated && !pedestal.playersInContainment.isEmpty()) {
            pedestal.checkWizardsAlive();
        }
    }

    private static void regenerate(RunestonePedestalBlockEntity pedestal, BlockPos pos) {
        pedestal.natural = true;
        pedestal.activated = false;
        pedestal.conquered = false;
        BlockPos chestPos = pos.m_7494_();
        BlockEntity blockEntity = pedestal.f_58857_.m_7702_(chestPos);
        if (!(blockEntity instanceof RandomizableContainerBlockEntity)) {
            pedestal.f_58857_.m_46961_(chestPos, false);
            pedestal.f_58857_.m_46597_(chestPos, Blocks.f_50087_.m_49966_());
            RunestonePedestalBlockEntity.regenerate(pedestal, pos);
            return;
        }
        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
        container.m_59626_(EBLootTables.SHRINE, pedestal.f_58857_.m_213780_().m_188505_());
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)container);
        if (data != null) {
            data.setArcaneLockOwner(UUID.randomUUID().toString());
        }
        pedestal.sync();
    }

    private void tryLinkContainer(BlockPos pos) {
        RandomizableContainerBlockEntity container;
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos.m_7494_());
        if (!(blockEntity instanceof RandomizableContainerBlockEntity) || ((RCBEAccessor)(container = (RandomizableContainerBlockEntity)blockEntity)).getLootTable() == null) {
            EBLogger.warn("Runestone Pedestal at {} is marked as natural but has no valid container block entity above it, check the structure and try to have a container block above it", pos);
            this.setNatural(false);
            return;
        }
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)container);
        if (data != null) {
            data.setArcaneLockOwner(UUID.randomUUID().toString());
        }
        this.setLinkedPos(pos.m_7494_());
    }

    private void checkEvent(BlockPos pos) {
        List nearbyPlayers = this.f_58857_.m_45976_(Player.class, new AABB(pos).m_82400_(7.0));
        nearbyPlayers.removeIf(player -> player.m_5833_() || !player.m_6084_());
        if (nearbyPlayers.isEmpty()) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        ParticleBuilder.create(EBParticles.SPHERE).pos(x, y + 1.0, z).color(15754389).scale(5.0f).time(12).allowServer(true).spawn(this.f_58857_);
        this.f_58857_.m_6263_(null, x, y, z, EBSounds.BLOCK_PEDESTAL_ACTIVATE.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
        this.activated = true;
        this.spawnedWizards.clear();
        this.playersInContainment.addAll(nearbyPlayers.stream().map(Entity::m_20148_).toList());
        this.containmentEffect();
        this.spawnEvilWizards();
        this.sync();
    }

    private void spawnEvilWizards() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Element element;
            EvilWizard wizard = new EvilWizard(this.f_58857_);
            BlockPos spawnPos = this.findSpawnPositionWizard(this.f_58857_.f_46441_.m_188501_() * 2.0f * (float)Math.PI);
            wizard.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            Block block = this.m_58900_().m_60734_();
            if (block instanceof RunestonePedestalBlock) {
                RunestonePedestalBlock runestone = (RunestonePedestalBlock)block;
                element = runestone.getElement();
            } else {
                element = Elements.FIRE;
            }
            wizard.setElement(element);
            wizard.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.STRUCTURE, null, null);
            this.f_58857_.m_7967_((Entity)wizard);
            this.spawnedWizards.add(wizard.m_20148_());
        }
    }

    private void containmentEffect() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.playersInContainment.removeIf(uuid -> {
            Player player = serverLevel.m_46003_(uuid);
            if (player == null || !player.m_6084_()) {
                return true;
            }
            this.setContainmentPos((LivingEntity)player);
            player.m_7292_(new MobEffectInstance(EBMobEffects.CONTAINMENT.get(), 200, 0, false, false, true));
            return false;
        });
        this.spawnedWizards.removeIf(uuid -> {
            Entity entity = serverLevel.m_8791_(uuid);
            if (entity == null || !entity.m_6084_()) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.setContainmentPos(livingEntity);
                livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.CONTAINMENT.get(), 200, 0, false, false, true));
            }
            return false;
        });
    }

    private void checkWizardsAlive() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.spawnedWizards.removeIf(uuid -> {
            Entity entity = serverLevel.m_8791_(uuid);
            return entity == null || !entity.m_6084_();
        });
        if (this.spawnedWizards.isEmpty()) {
            boolean playersEmpty = this.playersInContainment.isEmpty();
            this.conquered();
            if (playersEmpty) {
                RunestonePedestalBlockEntity.regenerate(this, this.m_58899_());
            }
        }
    }

    private void conquered() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_5594_(null, this.m_58899_(), EBSounds.BLOCK_PEDESTAL_CONQUER.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
        this.playersInContainment.forEach(uuid -> {
            Player player = serverLevel.m_46003_(uuid);
            if (player != null) {
                player.m_21195_(EBMobEffects.CONTAINMENT.get());
            }
        });
        this.playersInContainment.clear();
        this.spawnConqueredParticles();
        ArcaneLockData data = Services.OBJECT_DATA.getArcaneLockData(this.f_58857_.m_7702_(this.linkedPos));
        if (data != null) {
            data.clearArcaneLockOwner();
        }
        this.conquered = true;
        this.regenerationTime = this.f_58857_.m_46467_() + 72000L;
        this.sync();
    }

    private void spawnConqueredParticles() {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        ParticleBuilder.create(EBParticles.SPHERE).scale(5.0f).pos(x, y + 1.0, z).color(15754389).time(12).allowServer(true).spawn(this.f_58857_);
        for (int i = 0; i < 5; ++i) {
            float brightness = 0.8f + this.f_58857_.f_46441_.m_188501_() * 0.2f;
            ParticleBuilder.create(EBParticles.SPARKLE, this.f_58857_.f_46441_, x, y + 1.0, z, 1.0, true).color(1.0f, brightness, brightness).allowServer(true).spawn(this.f_58857_);
        }
    }

    private BlockPos findSpawnPositionWizard(float angle) {
        int x = (int)((double)this.m_58899_().m_123341_() + 0.5 + (double)(5.0f * Mth.m_14031_((float)angle)));
        int z = (int)((double)this.m_58899_().m_123343_() + 0.5 + (double)(5.0f * Mth.m_14089_((float)angle)));
        Integer y = BlockUtil.getNearestFloor(this.f_58857_, new BlockPos(x, this.m_58899_().m_123342_(), z), 8);
        return y != null ? new BlockPos(x, y.intValue(), z) : this.m_58899_().m_7918_(1, 0, 0);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.linkedPos != null) {
            tag.m_128365_("LinkedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.linkedPos));
        }
        tag.m_128379_("Natural", this.natural);
        tag.m_128379_("Activated", this.activated);
        tag.m_128379_("Conquered", this.conquered);
        tag.m_128356_("RegenerationTime", this.regenerationTime);
        this.saveUUIDList(tag, "SpawnedWizards", this.spawnedWizards);
        this.saveUUIDList(tag, "PlayersInContainment", this.playersInContainment);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.linkedPos = tag.m_128441_("LinkedPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LinkedPos")) : null;
        this.natural = tag.m_128471_("Natural");
        this.activated = tag.m_128471_("Activated");
        this.conquered = tag.m_128471_("Conquered");
        this.regenerationTime = tag.m_128454_("RegenerationTime");
        this.loadUUIDList(tag, "SpawnedWizards", this.spawnedWizards);
        this.loadUUIDList(tag, "PlayersInContainment", this.playersInContainment);
    }

    private void saveUUIDList(CompoundTag tag, String key, List<UUID> list) {
        if (list.isEmpty()) {
            return;
        }
        ListTag listTag = new ListTag();
        for (UUID uuid : list) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.m_128362_("UUID", uuid);
            listTag.add((Object)uuidTag);
        }
        tag.m_128365_(key, (Tag)listTag);
    }

    private void loadUUIDList(CompoundTag tag, String key, List<UUID> list) {
        list.clear();
        if (!tag.m_128441_(key)) {
            return;
        }
        ListTag listTag = tag.m_128437_(key, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            list.add(listTag.m_128728_(i).m_128342_("UUID"));
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    private void setContainmentPos(LivingEntity entity) {
        ContainmentData data = Services.OBJECT_DATA.getContainmentData(entity);
        data.setContainmentPos(this.f_58858_);
    }

    private void sync() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setLinkedPos(@Nullable BlockPos pos) {
        this.linkedPos = pos;
        this.sync();
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
        this.sync();
    }
}

