/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command;

import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class AllyCommand {
    private AllyCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ally").then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"origin", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ally", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(2))).executes(ctx -> AllyCommand.processAllyChange((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"origin"), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"ally"), true, "add")))).executes(ctx -> AllyCommand.executeAddAlly((CommandContext<CommandSourceStack>)ctx, (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"origin")))))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"origin", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ally", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(2))).executes(ctx -> AllyCommand.processAllyChange((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"origin"), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"ally"), false, "remove")))).executes(ctx -> AllyCommand.executeRemoveAlly((CommandContext<CommandSourceStack>)ctx, (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"origin"))))));
    }

    private static int processAllyChange(CommandSourceStack source, Player origin, Player ally, boolean addOperation, String opKey) {
        WizardData data = Services.OBJECT_DATA.getWizardData(origin);
        boolean result = data.toggleAlly(ally);
        boolean success = addOperation == result;
        String key = "commands.ebwizardry:ally." + opKey + (success ? ".success" : ".failure");
        source.m_243053_((Component)Component.m_237110_((String)key, (Object[])new Object[]{origin.m_5446_(), ally.m_5446_()}));
        return success ? 1 : 0;
    }

    private static int executeAddAlly(CommandContext<CommandSourceStack> context, Player ally) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.ebwizardry:ally.add.failure", (Object[])new Object[]{ally.m_5446_()}));
            return 0;
        }
        ServerPlayer origin = source.m_81375_();
        return AllyCommand.processAllyChange(source, (Player)origin, ally, true, "add");
    }

    private static int executeRemoveAlly(CommandContext<CommandSourceStack> context, Player ally) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.ebwizardry:ally.remove.failure", (Object[])new Object[]{ally.m_5446_()}));
            return 0;
        }
        ServerPlayer origin = source.m_81375_();
        return AllyCommand.processAllyChange(source, (Player)origin, ally, false, "remove");
    }
}

