/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command;

import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.command.argument.SpellArgument;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class CastCommand {
    public static final int DEFAULT_CASTING_DURATION = 400;

    private CastCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cast").requires(p -> p.m_6761_(2))).then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgument.spell()).executes(context -> CastCommand.executePlayer((CommandContext<CommandSourceStack>)context, SpellArgument.getSpell((CommandContext<CommandSourceStack>)context, "spell")))));
    }

    private static int executePlayer(CommandContext<CommandSourceStack> context, Spell spell) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.ebwizardry.cast.player_only"));
            return 0;
        }
        if (spell == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.ebwizardry.cast.unknown_spell"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        SpellModifiers modifiers = new SpellModifiers();
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Pre(SpellCastEvent.Source.COMMAND, spell, (LivingEntity)player, modifiers))) {
            source.m_81352_((Component)Component.m_237115_((String)("commands.ebwizardry.cast.failure" + spell.getDescriptionId())));
            return 0;
        }
        if (!spell.isInstantCast()) {
            return CastCommand.handleContinuousSpell(source, spell, player, modifiers);
        }
        return CastCommand.handleInstantSpell(source, spell, player, modifiers);
    }

    private static int handleContinuousSpell(CommandSourceStack source, Spell spell, ServerPlayer player, SpellModifiers modifiers) {
        CastCommandData data = Services.OBJECT_DATA.getCastCommandData((Player)player);
        if (data.isCommandCasting()) {
            data.stopCastingContinuousSpell();
        } else {
            data.startCastingContinuousSpell(spell, modifiers, 400);
            source.m_243053_((Component)Component.m_237110_((String)"commands.ebwizardry.cast.success_continuous", (Object[])new Object[]{spell.getDescriptionId()}));
        }
        return 1;
    }

    private static int handleInstantSpell(CommandSourceStack source, Spell spell, ServerPlayer player, SpellModifiers modifiers) {
        if (spell.cast(new PlayerCastContext(player.m_9236_(), (Player)player, InteractionHand.MAIN_HAND, 0, modifiers))) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (LivingEntity)player, modifiers));
            source.m_243053_((Component)Component.m_237110_((String)"commands.ebwizardry.cast.success", (Object[])new Object[]{spell.getDescriptionFormatted()}));
        }
        return 0;
    }
}

