/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public final class SpellContextCommand {
    private static final SuggestionProvider<CommandSourceStack> CONTEXT_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])SpellContext.getAllKeys(), (SuggestionsBuilder)builder);

    private SpellContextCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spellContext").requires(p -> p.m_6761_(2))).then(Commands.m_82129_((String)"context", (ArgumentType)StringArgumentType.word()).suggests(CONTEXT_SUGGESTIONS).executes(c -> SpellContextCommand.listSpellsByContext((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"context")))));
    }

    private static int listSpellsByContext(CommandSourceStack source, String context) {
        if (!SpellContext.isValidKey(context)) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid context: " + context)).m_130940_(ChatFormatting.RED));
            source.m_243053_((Component)Component.m_237113_((String)("Valid contexts: " + String.join((CharSequence)", ", SpellContext.getAllKeys()))).m_130940_(ChatFormatting.GRAY));
            return 0;
        }
        SpellContext spellContext = SpellContext.fromKey(context);
        List<Spell> enabledSpells = Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> spell.isEnabled(spellContext)).toList();
        List<Spell> disabledSpells = Services.REGISTRY_UTIL.getSpells().stream().filter(spell -> !spell.isEnabled(spellContext)).toList();
        source.m_243053_((Component)Component.m_237113_((String)"=".repeat(50)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        source.m_243053_((Component)Component.m_237113_((String)"Spells for context: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)context).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        source.m_243053_((Component)Component.m_237113_((String)"=".repeat(50)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        source.m_243053_((Component)Component.m_237113_((String)("\n\u2713 ENABLED (" + enabledSpells.size() + ")")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        if (enabledSpells.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"  No enabled spells").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            for (Spell spell2 : enabledSpells) {
                source.m_243053_((Component)Component.m_237113_((String)"  \u2022 ").m_130940_(ChatFormatting.GREEN).m_7220_(spell2.getDescriptionFormatted()).m_7220_((Component)Component.m_237113_((String)(" [" + String.valueOf(spell2.getLocation()) + "]")).m_130940_(ChatFormatting.GRAY)));
            }
        }
        source.m_243053_((Component)Component.m_237113_((String)("\n\u2717 DISABLED (" + disabledSpells.size() + ")")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        if (disabledSpells.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"  No disabled spells").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            for (Spell spell2 : disabledSpells) {
                source.m_243053_((Component)Component.m_237113_((String)"  \u2022 ").m_130940_(ChatFormatting.RED).m_7220_(spell2.getDescriptionFormatted()).m_7220_((Component)Component.m_237113_((String)(" [" + String.valueOf(spell2.getLocation()) + "]")).m_130940_(ChatFormatting.GRAY)));
            }
        }
        source.m_243053_((Component)Component.m_237113_((String)"=".repeat(50)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        return 1;
    }
}

