/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command.debug;

import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.content.command.argument.SpellArgument;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class DiscoverSpellCommand {
    private DiscoverSpellCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"discover").then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgument.spell()).executes(c -> DiscoverSpellCommand.execute((CommandContext<CommandSourceStack>)c, SpellArgument.getSpell((CommandContext<CommandSourceStack>)c, "spell")))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, Spell spell) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237115_((String)"command.ebwizardry.discover.not_player"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        if (spell == null) {
            source.m_81352_((Component)Component.m_237115_((String)"command.ebwizardry.discover.spell_not_found"));
            return 0;
        }
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData((Player)player);
        if (data.hasSpellBeenDiscovered(spell)) {
            source.m_81352_((Component)Component.m_237110_((String)"command.ebwizardry.discover.already_discovered", (Object[])new Object[]{spell.getDescriptionFormatted()}));
            return 0;
        }
        data.discoverSpell(spell);
        source.m_243053_((Component)Component.m_237110_((String)"command.ebwizardry.discover.success", (Object[])new Object[]{spell.getDescriptionFormatted()}));
        return 1;
    }
}

