/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command.debug;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.item.WandItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WandSelectCommand {
    private static final SuggestionProvider<CommandSourceStack> MODE_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("next", "previous"), (SuggestionsBuilder)builder);

    private WandSelectCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wandselect").then(Commands.m_82127_((String)"mode").then(Commands.m_82129_((String)"option", (ArgumentType)StringArgumentType.word()).suggests(MODE_SUGGESTIONS).executes(ctx -> WandSelectCommand.executeMode((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"option")))))).then(Commands.m_82127_((String)"index").then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> WandSelectCommand.executeIndex((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot"))))));
    }

    private static int executeMode(CommandContext<CommandSourceStack> context, String option) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You need to be a player to execute this!"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        ItemStack wandStack = player.m_21205_();
        if (!(wandStack.m_41720_() instanceof WandItem)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be holding a wand!"));
            return 0;
        }
        Spell newSelected = option.equalsIgnoreCase("previous") ? WandHelper.getPreviousSpell(wandStack) : (option.equalsIgnoreCase("next") ? WandHelper.getNextSpell(wandStack) : WandHelper.getCurrentSpell(wandStack));
        WandHelper.setCurrentSpell(wandStack, newSelected);
        source.m_243053_((Component)Component.m_237113_((String)("Spell selected: " + newSelected.getDescriptionId())));
        return 1;
    }

    private static int executeIndex(CommandContext<CommandSourceStack> context, int slot) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You need to be a player to execute this!"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        ItemStack wandStack = player.m_21205_();
        Item item = wandStack.m_41720_();
        if (!(item instanceof WandItem)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be holding a wand!"));
            return 0;
        }
        WandItem wandItem = (WandItem)item;
        int maxSlots = wandItem.getSpellSlotCount(wandStack);
        if (slot < 0 || slot >= maxSlots) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid slot number. Must be between 0 and " + (maxSlots - 1))));
            return 0;
        }
        List<Spell> spells = WandHelper.getSpells(wandStack);
        Spell newSelected = spells.get(slot);
        WandHelper.setCurrentSpell(wandStack, newSelected);
        source.m_243053_((Component)Component.m_237113_((String)("Spell selected: " + newSelected.getDescriptionId() + " at " + slot)));
        return 1;
    }
}

