/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command.debug;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.command.argument.SpellArgument;
import com.binaris.wizardry.content.item.WandItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class WandSpellCommand {
    private WandSpellCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wand").then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgument.spell()).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WandSpellCommand.execute((CommandContext<CommandSourceStack>)c, SpellArgument.getSpell((CommandContext<CommandSourceStack>)c, "spell"), IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, Spell spell, int slot) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237115_((String)"command.ebwizardry.wand.not_player"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof WandItem)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.ebwizardry.wand.not_holding_wand"));
            return 0;
        }
        WandItem wandItem = (WandItem)item;
        if (spell == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.ebwizardry.wand.spell_not_found"));
            return 0;
        }
        int maxSlots = wandItem.getSpellSlotCount(stack);
        if (slot < 0 || slot >= maxSlots) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.ebwizardry.wand.invalid_slot", (Object[])new Object[]{maxSlots - 1}));
            return 0;
        }
        List<Spell> spells = WandHelper.getSpells(stack);
        int currentSelectedIndex = spells.indexOf(WandHelper.getCurrentSpell(stack));
        spells.set(slot, spell);
        if (currentSelectedIndex == slot) {
            WandHelper.setCurrentSpell(stack, spell);
        }
        WandHelper.setSpells(stack, spells);
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)"command.ebwizardry.wand.success", (Object[])new Object[]{spell.getLocation(), slot}));
        return 1;
    }
}

