/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.command.debug;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.item.WandItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public final class WandSpellListCommand {
    private WandSpellListCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"wand_spells").executes(WandSpellListCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You need to be a player to execute this!"));
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof WandItem)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be holding a wand!"));
            return 0;
        }
        List<Spell> spells = WandHelper.getSpells(stack);
        for (Spell spell : spells) {
            if (WandHelper.getCurrentSpell(stack) == spell) {
                player.m_213846_((Component)Component.m_237113_((String)"Spell at %s is currently active".formatted(spells.indexOf(spell))).m_130940_(ChatFormatting.YELLOW));
                continue;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Spell at %s is %s".formatted(spells.indexOf(spell), spell.getLocation())));
        }
        return 1;
    }
}

