/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.data;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.event.EBServerLevelLoadEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;

public class SpellGlyphData
extends SavedData {
    private static final String NAME = "ebwizardry_glyphData";
    public Map<Spell, String> randomNames = new HashMap<Spell, String>();
    public Map<Spell, String> randomDescriptions = new HashMap<Spell, String>();

    public static SpellGlyphData get(ServerLevel world) {
        SpellGlyphData instance = (SpellGlyphData)world.m_8895_().m_164858_(SpellGlyphData::load, NAME);
        if (instance == null) {
            instance = new SpellGlyphData();
        }
        boolean changed = false;
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            if (!instance.randomNames.containsKey(spell)) {
                instance.randomNames.put(spell, instance.generateRandomName(world.f_46441_));
                changed = true;
            }
            if (instance.randomDescriptions.containsKey(spell)) continue;
            instance.randomDescriptions.put(spell, instance.generateRandomDescription(world.f_46441_));
            changed = true;
        }
        if (changed) {
            instance.m_77762_();
            world.m_8895_().m_164855_(NAME, (SavedData)instance);
        }
        return instance;
    }

    public static Component getGlyphNameFormatted(Spell spell, SpellGlyphData data) {
        return Component.m_237113_((String)SpellGlyphData.getGlyphName(spell, data)).m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt")));
    }

    public static String getGlyphName(Spell spell, SpellGlyphData data) {
        Map<Spell, String> names = data.randomNames;
        return names == null ? "" : names.getOrDefault(spell, "");
    }

    public static String getGlyphDescription(Spell spell, SpellGlyphData data) {
        Map<Spell, String> descriptions = data.randomDescriptions;
        return descriptions == null ? "" : descriptions.getOrDefault(spell, "");
    }

    public static String getGlyphName(Spell spell, ServerLevel world) {
        Map<Spell, String> names = SpellGlyphData.get((ServerLevel)world).randomNames;
        return names == null ? "" : names.getOrDefault(spell, "");
    }

    public static String getGlyphDescription(Spell spell, ServerLevel world) {
        Map<Spell, String> descriptions = SpellGlyphData.get((ServerLevel)world).randomDescriptions;
        return descriptions == null ? "" : descriptions.getOrDefault(spell, "");
    }

    public static SpellGlyphData load(CompoundTag nbt) {
        SpellGlyphData data = new SpellGlyphData();
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        ListTag tagList = nbt.m_128437_("spellGlyphData", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            String spellStr = tag.m_128461_("spell");
            ResourceLocation loc = ResourceLocation.m_135820_((String)spellStr);
            if (loc == null) {
                EBLogger.warn("Skipping malformed spell entry in glyph data: " + spellStr, new Object[0]);
                continue;
            }
            Spell spell = Services.REGISTRY_UTIL.getSpell(loc);
            if (spell == null) {
                EBLogger.info("Skipping unknown spell in glyph data: " + String.valueOf(loc), new Object[0]);
                continue;
            }
            data.randomNames.put(spell, tag.m_128461_("name"));
            data.randomDescriptions.put(spell, tag.m_128461_("description"));
        }
        return data;
    }

    public static void onServerLevelLoad(EBServerLevelLoadEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        if (level.m_46472_().m_135782_().m_135815_().equals("overworld")) {
            SpellGlyphData.get(level);
        }
    }

    public void generateGlyphNames(Level world) {
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            if (!this.randomNames.containsKey(spell)) {
                this.randomNames.put(spell, this.generateRandomName(world.f_46441_));
            }
            if (this.randomDescriptions.containsKey(spell)) continue;
            this.randomDescriptions.put(spell, this.generateRandomDescription(world.f_46441_));
        }
        this.m_77762_();
    }

    private String generateRandomName(RandomSource random) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
            name.append(RandomStringUtils.random((int)(3 + random.m_188503_(5)), (String)"abcdefghijklmnopqrstuvwxyz")).append(" ");
        }
        return name.toString().trim();
    }

    private String generateRandomDescription(RandomSource random) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < random.m_188503_(16) + 8; ++i) {
            name.append(RandomStringUtils.random((int)(2 + random.m_188503_(7)), (String)"abcdefghijklmnopqrstuvwxyz")).append(" ");
        }
        return name.toString().trim();
    }

    public void sync(ServerPlayer player) {
        HashMap<ResourceLocation, String> names = new HashMap<ResourceLocation, String>();
        HashMap<ResourceLocation, String> descriptions = new HashMap<ResourceLocation, String>();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            names.put(spell.getLocation(), this.randomNames.get(spell));
            descriptions.put(spell.getLocation(), this.randomDescriptions.get(spell));
        }
        SpellGlyphPacketS2C msg = new SpellGlyphPacketS2C(names, descriptions);
        Services.NETWORK_HELPER.sendTo(player, msg);
        EBLogger.info("Synchronising spell glyph data for " + player.m_7755_().getString(), new Object[0]);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag tagList = new ListTag();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("spell", spell.getLocation().toString());
            if (this.randomNames.get(spell) != null) {
                tag.m_128359_("name", this.randomNames.get(spell));
            }
            if (this.randomDescriptions.get(spell) != null) {
                tag.m_128359_("description", this.randomDescriptions.get(spell));
            }
            tagList.add((Object)tag);
        }
        NBTExtras.storeTagSafely(nbt, "spellGlyphData", (Tag)tagList);
        return nbt;
    }
}

