/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.effect;

import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.api.content.effect.MagicMobEffect;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ContainmentEffect
extends MagicMobEffect {
    public ContainmentEffect() {
        super(MobEffectCategory.NEUTRAL, 7964876);
    }

    public static float getContainmentDistance(int effectStrength) {
        return 15 - effectStrength * 4;
    }

    public static void onLivingUpdateEvent(EBLivingTick event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_6084_()) {
            return;
        }
        ContainmentData data = Services.OBJECT_DATA.getContainmentData(entity);
        if (entity.f_19797_ % 20 == 0 && data.getContainmentPos() != null && !entity.m_21023_(EBMobEffects.CONTAINMENT.get())) {
            data.setContainmentPos(null);
        }
    }

    public void m_6742_(@NotNull LivingEntity target, int amplifier) {
        if (!target.m_6084_()) {
            return;
        }
        float maxDistance = ContainmentEffect.getContainmentDistance(amplifier);
        ContainmentData data = Services.OBJECT_DATA.getContainmentData(target);
        if (data.getContainmentPos() == null) {
            data.setContainmentPos(target.m_20183_().m_7918_(-1, -1, -1));
        }
        Vec3 origin = GeometryUtil.getCentre(data.getContainmentPos());
        double x = target.f_19854_;
        double y = target.f_19855_;
        double z = target.f_19856_;
        if (target.m_20191_().f_82291_ > origin.f_82479_ + (double)maxDistance) {
            x = origin.f_82479_ + (double)maxDistance - (double)(target.m_20205_() / 2.0f);
        }
        if (target.m_20191_().f_82288_ < origin.f_82479_ - (double)maxDistance) {
            x = origin.f_82479_ - (double)maxDistance + (double)(target.m_20205_() / 2.0f);
        }
        if (target.m_20191_().f_82292_ > origin.f_82480_ + (double)maxDistance) {
            y = origin.f_82480_ + (double)maxDistance - (double)target.m_20206_();
        }
        if (target.m_20191_().f_82289_ < origin.f_82480_ - (double)maxDistance) {
            y = origin.f_82480_ - (double)maxDistance;
        }
        if (target.m_20191_().f_82293_ > origin.f_82481_ + (double)maxDistance) {
            z = origin.f_82481_ + (double)maxDistance - (double)(target.m_20205_() / 2.0f);
        }
        if (target.m_20191_().f_82290_ < origin.f_82481_ - (double)maxDistance) {
            z = origin.f_82481_ - (double)maxDistance + (double)(target.m_20205_() / 2.0f);
        }
        if (x != target.f_19854_ || y != target.f_19855_ || z != target.f_19856_) {
            target.m_246865_(new Vec3(0.15 * Math.signum(x - target.f_19854_), 0.15 * Math.signum(y - target.f_19855_), 0.15 * Math.signum(z - target.f_19856_)));
            EntityUtil.undoGravity((Entity)target);
            if (target.m_9236_().f_46443_) {
                target.m_9236_().m_5594_(null, target.m_20183_(), EBSounds.ENTITY_FORCEFIELD_DEFLECT.get(), SoundSource.HOSTILE, 0.3f, 1.0f);
            }
        }
        if (target.m_21023_((MobEffect)this) && target.m_21124_((MobEffect)this).m_19557_() <= 1 && target.m_21124_((MobEffect)this).m_19557_() != -1) {
            data.setContainmentPos(null);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    @Override
    public void spawnCustomParticle(Level world, double x, double y, double z) {
    }
}

