/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity;

import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MeteorEntity
extends FallingBlockEntity {
    public float blastMultiplier;
    private boolean damageBlocks;

    public MeteorEntity(EntityType<? extends FallingBlockEntity> entityType, Level level) {
        super(entityType, level);
    }

    public MeteorEntity(Level level) {
        super(EBEntities.METEOR.get(), level);
    }

    public MeteorEntity(Level level, double x, double y, double z, BlockState state) {
        this(EBEntities.METEOR.get(), level);
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.m_31959_(this.m_20183_());
    }

    public MeteorEntity(Level world, double x, double y, double z, float blastMultiplier, boolean damageBlocks) {
        this(world, x, y, z, Blocks.f_50450_.m_49966_());
        this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.1, this.m_20184_().f_82481_);
        this.m_20254_(200);
        this.blastMultiplier = blastMultiplier;
        this.damageBlocks = damageBlocks;
        this.f_19811_ = true;
    }

    public double m_6049_() {
        return this.m_20206_() / 2.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ % 16 == 1 && this.m_9236_().f_46443_) {
            ClientSpellSoundManager.playMovingSound((Entity)this, EBSounds.ENTITY_METEOR_FALLING.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        ++this.f_31942_;
        this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.1, this.m_20184_().f_82481_);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_((double)0.98f, (double)0.98f, (double)0.98f));
        if (!this.m_20096_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_().m_82542_((double)0.7f, -0.5, (double)0.7f));
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.MOB);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), Spells.METEOR.property(DefaultProperties.DAMAGE).floatValue() * this.blastMultiplier, this.damageBlocks, this.damageBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public boolean m_142535_(float v1, float v, @NotNull DamageSource source) {
        return false;
    }

    public boolean m_6051_() {
        return true;
    }

    @NotNull
    public BlockState m_31980_() {
        return Blocks.f_50450_.m_49966_();
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.blastMultiplier = tag.m_128457_("blastMultiplier");
        this.damageBlocks = tag.m_128471_("damageBlocks");
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("blastMultiplier", this.blastMultiplier);
        tag.m_128379_("damageBlocks", this.damageBlocks);
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }
}

