/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BlizzardConstruct
extends ScaledConstructEntity {
    public BlizzardConstruct(EntityType<?> type, Level level) {
        super(type, level);
        this.lifetime = Spells.BLIZZARD.property(DefaultProperties.DURATION);
    }

    public BlizzardConstruct(Level world) {
        super(EBEntities.BLIZZARD.get(), world);
        this.lifetime = Spells.BLIZZARD.property(DefaultProperties.DURATION);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 120 == 1) {
            this.m_5496_(EBSounds.ENTITY_BLIZZARD_AMBIENT.get(), 1.0f, 1.0f);
        }
        double radius = (float)Spells.BLIZZARD.property(DefaultProperties.EFFECT_RADIUS).intValue() * this.sizeMultiplier;
        if (!this.m_9236_().f_46443_) {
            List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(radius, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
            for (LivingEntity target : targets) {
                if (this.isValidTarget((Entity)target)) {
                    EntityUtil.attackEntityWithoutKnockback((Entity)target, this.getCaster() != null ? MagicDamageSource.causeIndirectMagicDamage(this, (Entity)this.getCaster(), EBDamageSources.FROST) : MagicDamageSource.causeDirectMagicDamage(this, EBDamageSources.SORCERY), 1.0f * this.damageMultiplier);
                }
                target.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), 20));
            }
        } else {
            double speed;
            int i;
            for (i = 0; i < 6; ++i) {
                speed = (double)(this.f_19796_.m_188499_() ? 1 : -1) * (0.1 + 0.05 * this.f_19796_.m_188500_());
                ParticleBuilder.create(EBParticles.SNOW).pos(this.m_20185_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_()).velocity(0.0, 0.0, 0.0).time(100).scale(2.0f).spin(this.f_19796_.m_188500_() * (radius - 0.5) + 0.5, speed).shaded(true).spawn(this.m_9236_());
            }
            for (i = 0; i < 3; ++i) {
                speed = (double)(this.f_19796_.m_188499_() ? 1 : -1) * (0.05 + 0.02 * this.f_19796_.m_188500_());
                ParticleBuilder.create(EBParticles.CLOUD).pos(this.m_20185_(), this.m_20186_() + this.f_19796_.m_188500_() * ((double)this.m_20206_() - 0.5), this.m_20189_()).color(0xFFFFFF).shaded(true).spin(this.f_19796_.m_188500_() * (radius - 1.0) + 0.5, speed).spawn(this.m_9236_());
            }
        }
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return EntityDimensions.m_20395_((float)(Spells.BLIZZARD.property(DefaultProperties.EFFECT_RADIUS) * 2), (float)3.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }
}

