/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.earth.Boulder;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BoulderConstruct
extends ScaledConstructEntity {
    private static final double AIR_FRICTION = 0.99;
    private static final double GROUND_FRICTION = 0.985;
    private boolean soundStarted = false;

    public BoulderConstruct(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = false;
        this.m_20242_(false);
        this.lifetime = Spells.BOULDER.property(DefaultProperties.DURATION);
    }

    public BoulderConstruct(Level world) {
        super(EBEntities.BOULDER.get(), world);
        this.f_19794_ = false;
        this.m_20242_(false);
        this.lifetime = Spells.BOULDER.property(DefaultProperties.DURATION);
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.m_20334_(velX, this.m_20184_().f_82480_, velZ);
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_ && !this.soundStarted && this.m_20096_()) {
            this.soundStarted = true;
            ClientSpellSoundManager.playMovingSound(this, EBSounds.ENTITY_BOULDER_ROLL.get(), SoundSource.PLAYERS, 1.0f, 1.0f, true);
        }
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double newY = motion.f_82480_ - 0.04;
        double friction = this.m_20096_() ? 0.985 : 0.99;
        double newX = motion.f_82479_ * friction;
        double newZ = motion.f_82481_ * friction;
        this.m_20334_(newX, newY, newZ);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        List collided = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
        float damage = Spells.BOULDER.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
        float knockback = Spells.BOULDER.property(Boulder.KNOCKBACK_STRENGTH).floatValue();
        for (LivingEntity entity : collided) {
            if (!this.isValidTarget((Entity)entity)) continue;
            boolean crushBonus = entity.m_20186_() < this.m_20186_() && entity.m_20191_().f_82288_ > this.m_20191_().f_82288_ && entity.m_20191_().f_82291_ < this.m_20191_().f_82291_ && entity.m_20191_().f_82290_ > this.m_20191_().f_82290_ && entity.m_20191_().f_82293_ < this.m_20191_().f_82293_;
            if (EntityUtil.attackEntityWithoutKnockback((Entity)entity, MagicDamageSource.causeIndirectMagicDamage(this, (Entity)this.getCaster(), EBDamageSources.SORCERY), crushBonus ? damage * 1.5f : damage) && !crushBonus) {
                EntityUtil.applyStandardKnockback(this, entity, knockback);
                entity.m_20256_(entity.m_20184_().m_82520_(motion.f_82479_, 0.0, motion.f_82481_));
            }
            entity.m_5496_(EBSounds.ENTITY_BOULDER_HIT.get(), 1.0f, 1.0f);
        }
        if (this.f_19862_) {
            this.shakeNearbyPlayers();
        }
        if (this.m_20096_()) {
            for (int i = 0; i < 10; ++i) {
                double particleX = this.m_20185_() + (double)this.m_20205_() * 0.7 * (this.f_19796_.m_188500_() - 0.5);
                double particleZ = this.m_20189_() + (double)this.m_20205_() * 0.7 * (this.f_19796_.m_188500_() - 0.5);
                BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                if (block.m_60734_() == Blocks.f_50016_) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), particleX, this.m_20186_(), particleZ, 0.0, 0.2, 0.0);
            }
        }
        if (this.m_20096_() && motion.m_165924_() < 0.005) {
            this.despawn();
        }
    }

    private void shakeNearbyPlayers() {
    }

    @Override
    public void despawn() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 200; ++i) {
                double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                double y = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), x, y, z, (x - this.m_20185_()) * 0.1, (y - this.m_20186_() + (double)(this.m_20206_() / 2.0f)) * 0.1, (z - this.m_20189_()) * 0.1);
            }
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), EBSounds.ENTITY_BOULDER_BREAK_BLOCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        super.despawn();
    }

    public void m_6478_(@NotNull MoverType type, @NotNull Vec3 vec) {
        super.m_6478_(type, vec);
        double distance = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
        this.m_146926_((float)((double)this.m_146909_() + Math.toDegrees(distance / (double)(this.m_20205_() / 2.0f))));
    }

    public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource source) {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 40; ++i) {
                double particleX = this.m_20185_() - 1.5 + 3.0 * this.f_19796_.m_188500_();
                double particleZ = this.m_20189_() - 1.5 + 3.0 * this.f_19796_.m_188500_();
                BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_175288_(this.m_20183_().m_123342_() - 2));
                if (block.m_60734_() == Blocks.f_50016_) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), particleX, this.m_20186_(), particleZ, particleX - this.m_20185_(), 0.0, particleZ - this.m_20189_());
            }
            if ((double)distance > 1.2) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), EBSounds.ENTITY_BOULDER_LAND.get(), SoundSource.BLOCKS, Math.min(2.0f, distance / 4.0f), 1.0f, false);
                this.shakeNearbyPlayers();
            }
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_();
    }
}

