/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.necromancy.Entrapment;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import java.lang.ref.WeakReference;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BubbleConstruct
extends MagicConstructEntity {
    private static final EntityDataAccessor<Boolean> IS_DARK_ORB = SynchedEntityData.m_135353_(BubbleConstruct.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private WeakReference<LivingEntity> rider;

    public BubbleConstruct(EntityType<?> type, Level world) {
        super(type, world);
    }

    public BubbleConstruct(Level world) {
        super(EBEntities.BUBBLE.get(), world);
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        BubbleConstruct bubble;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getDamagedEntity();
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof BubbleConstruct && !(bubble = (BubbleConstruct)entity2).isDarkOrb()) {
            bubble.m_5496_(EBSounds.ENTITY_BUBBLE_POP.get(), 1.5f, 1.0f);
            bubble.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity ref;
        LivingEntity living;
        super.m_8119_();
        Entity currentRider = EntityUtil.getRider(this);
        if ((this.rider == null || this.rider.get() == null) && currentRider instanceof LivingEntity && (living = (LivingEntity)currentRider).m_6084_()) {
            this.rider = new WeakReference<LivingEntity>(living);
        }
        if (currentRider == null && this.rider != null && (ref = (LivingEntity)this.rider.get()) != null && ref.m_6084_()) {
            ref.m_20329_((Entity)this);
        }
        if (this.f_19797_ < 1 && !this.isDarkOrb() && currentRider instanceof LivingEntity) {
            ((LivingEntity)currentRider).f_20916_ = 0;
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.03, 0.0));
        if (this.isDarkOrb()) {
            if (currentRider != null && currentRider.f_19797_ % Spells.ENTRAPMENT.property(Entrapment.DAMAGE_INTERVAL) == 0) {
                MagicDamageSource.causeMagicDamage(this, currentRider, 1.0f * this.damageMultiplier, EBDamageSources.SORCERY);
            }
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() + 0.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (currentRider == null && this.f_19797_ > 1) {
            if (!this.isDarkOrb()) {
                this.m_5496_(EBSounds.ENTITY_BUBBLE_POP.get(), 1.5f, 1.0f);
            }
            this.m_146870_();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DARK_ORB, (Object)false);
    }

    public boolean isDarkOrb() {
        return (Boolean)this.f_19804_.m_135370_(IS_DARK_ORB);
    }

    public void setDarkOrb(boolean isDarkOrb) {
        this.f_19804_.m_135381_(IS_DARK_ORB, (Object)isDarkOrb);
    }

    @Override
    public void despawn() {
        Entity rider = EntityUtil.getRider(this);
        if (rider instanceof LivingEntity) {
            rider.m_8127_();
        }
        if (!this.isDarkOrb()) {
            this.m_5496_(EBSounds.ENTITY_BUBBLE_POP.get(), 1.5f, 1.0f);
        }
        super.despawn();
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setDarkOrb(tag.m_128471_("isDarkOrb"));
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isDarkOrb", this.isDarkOrb());
    }

    public double m_6048_() {
        return 0.1;
    }

    protected boolean m_7341_(@NotNull Entity entity) {
        if (EntityUtil.getRider(this) != null) {
            return false;
        }
        return super.m_7341_(entity);
    }
}

