/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FireRingConstruct
extends ScaledConstructEntity {
    public FireRingConstruct(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public FireRingConstruct(Level world) {
        super(EBEntities.RING_OF_FIRE.get(), world);
        this.lifetime = Spells.RING_OF_FIRE.property(DefaultProperties.DURATION);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 40 == 1) {
            this.m_5496_(EBSounds.ENTITY_FIRE_RING_AMBIENT.get(), 4.0f, 0.7f);
        }
        if (this.f_19797_ % 5 != 0 || this.m_9236_().f_46443_) {
            return;
        }
        List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(this.m_20205_() / 2.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
        for (LivingEntity target : targets) {
            if (!this.isValidTarget((Entity)target) || MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (Entity)target)) continue;
            Vec3 originalVec = target.m_20184_();
            target.m_20254_(Spells.RING_OF_FIRE.property(DefaultProperties.EFFECT_DURATION).intValue());
            float damage = Spells.RING_OF_FIRE.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            MagicDamageSource.causeMagicDamage(this, (Entity)target, damage, EBDamageSources.FIRE);
            target.m_20256_(originalVec);
        }
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return EntityDimensions.m_20395_((float)(Spells.RING_OF_FIRE.property(DefaultProperties.EFFECT_RADIUS) * 2), (float)1.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }
}

