/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.ICustomHitbox;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.setup.registries.EBSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceBarrierConstruct
extends ScaledConstructEntity
implements ICustomHitbox {
    private static final double THICKNESS = 0.4;
    private int delay = 0;

    public IceBarrierConstruct(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.lifetime += delay;
    }

    public void m_19915_(float yaw, float pitch) {
        super.m_19915_(yaw, pitch);
        float a = Mth.m_14089_((float)((float)Math.toRadians(this.m_146908_())));
        float b = Mth.m_14031_((float)((float)Math.toRadians(this.m_146908_())));
        double x = (double)(this.m_20205_() / 2.0f * a) + 0.2 * (double)b;
        double z = (double)(this.m_20205_() / 2.0f * b) + 0.2 * (double)a;
        this.m_20011_(new AABB(this.m_20185_() - x, this.m_20186_(), this.m_20189_() - z, this.m_20185_() + x, this.m_20186_() + (double)this.m_20206_(), this.m_20189_() + z));
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_ && this.f_19803_) {
            this.setSizeMultiplier(this.sizeMultiplier);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        if (!this.m_9236_().f_46443_) {
            double extensionSpeed = 0.0;
            if (this.lifetime - this.f_19797_ < 20) {
                extensionSpeed = -0.01 * (double)(this.f_19797_ - (this.lifetime - 20)) * (double)this.sizeMultiplier;
            } else if (this.f_19797_ > 3 + this.delay) {
                extensionSpeed = 0.0;
            } else if (this.f_19797_ > this.delay) {
                extensionSpeed = 0.5 * (double)this.sizeMultiplier;
            }
            this.m_6478_(MoverType.SELF, new Vec3(0.0, extensionSpeed, 0.0));
        }
        if (this.f_19797_ == this.delay + 1) {
            this.m_5496_(EBSounds.ENTITY_ICE_BARRIER_EXTEND.get(), 1.0f, 1.5f);
        }
        super.m_8119_();
        Vec3 look = this.m_20154_();
        if (!this.m_9236_().f_46443_) {
            for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(2.0))) {
                double perpendicularDist;
                if (entity instanceof ScaledConstructEntity || !entity.m_20191_().m_82381_(this.m_20191_()) || !(Math.abs(perpendicularDist = this.getSignedPerpendicularDistance(entity.m_20182_().m_82520_(1.0, 0.0, 1.0))) < (double)(entity.m_20205_() / 2.0f) + 0.2)) continue;
                double velocity = 0.25 * Math.signum(perpendicularDist);
                entity.m_5997_(velocity * look.f_82479_, 0.0, velocity * look.f_82481_);
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        this.m_5496_(EBSounds.ENTITY_ICE_BARRIER_DEFLECT.get(), 0.7f, 2.5f);
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.delay = nbt.m_128451_("delay");
    }

    @Override
    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("delay", this.delay);
    }

    @Override
    public Vec3 calculateIntercept(Vec3 origin, Vec3 endpoint, float fuzziness) {
        Vec3 vec = endpoint.m_82546_(origin);
        double perpendicularDist = this.getPerpendicularDistance(origin);
        double perpendicularDist2 = this.getPerpendicularDistance(endpoint);
        Vec3 intercept = origin.m_82549_(vec.m_82490_(perpendicularDist / (perpendicularDist + perpendicularDist2)));
        return this.m_20191_().m_82400_((double)fuzziness).m_82390_(intercept) ? intercept : null;
    }

    @Override
    public boolean contains(Vec3 point) {
        return this.m_20191_().m_82390_(point) && this.getPerpendicularDistance(point) < 0.2;
    }

    private double getPerpendicularDistance(Vec3 point) {
        return Math.abs(this.getSignedPerpendicularDistance(point));
    }

    private double getSignedPerpendicularDistance(Vec3 point) {
        Vec3 look = this.m_20154_();
        Vec3 delta = new Vec3(point.f_82479_ - this.m_20185_(), 0.0, point.f_82481_ - this.m_20189_());
        return delta.m_82526_(look);
    }
}

