/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class IceSpikeConstruct
extends ScaledConstructEntity {
    private Direction facing;

    public IceSpikeConstruct(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public IceSpikeConstruct(Level world) {
        super(EBEntities.ICE_SPICKES.get(), world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.lifetime - this.f_19797_ == 30) {
            this.m_5496_(EBSounds.ENTITY_ICE_SPIKE_EXTEND.get(), 1.0f, 2.5f);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        double extensionSpeed = 0.0;
        if (this.lifetime - this.f_19797_ < 15) {
            extensionSpeed = -0.01 * (double)(this.f_19797_ - (this.lifetime - 15));
        } else if (this.lifetime - this.f_19797_ < 25) {
            extensionSpeed = 0.0;
        } else if (this.lifetime - this.f_19797_ < 28) {
            extensionSpeed = 0.25;
        }
        if (this.facing != null) {
            this.m_6478_(MoverType.SELF, new Vec3((double)this.facing.m_122429_() * extensionSpeed, (double)this.facing.m_122430_() * extensionSpeed, (double)this.facing.m_122431_() * extensionSpeed));
        }
        for (Object entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_())) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.isValidTarget((Entity)(livingEntity = (LivingEntity)entity)) || !MagicDamageSource.causeMagicDamage(this, (Entity)livingEntity, 5.0f * this.damageMultiplier, EBDamageSources.FROST)) continue;
            livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_SPICKES.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_SPICKES.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        }
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.m_19915_(-facing.m_122435_(), GeometryUtil.getPitch(facing));
        float yaw = -facing.m_122435_() * (float)Math.PI / 180.0f;
        float pitch = (GeometryUtil.getPitch(facing) - 90.0f) * (float)Math.PI / 180.0f;
        Vec3 min = this.m_20182_().m_82549_(new Vec3((double)(-this.m_20205_() / 2.0f), 0.0, (double)(-this.m_20205_() / 2.0f)).m_82496_(pitch).m_82524_(yaw));
        Vec3 max = this.m_20182_().m_82549_(new Vec3((double)(this.m_20205_() / 2.0f), (double)this.m_20206_(), (double)(this.m_20205_() / 2.0f)).m_82496_(pitch).m_82524_(yaw));
        this.m_20011_(new AABB(min.f_82479_, min.f_82480_, min.f_82481_, max.f_82479_, max.f_82480_, max.f_82481_));
    }
}

