/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LightningSigilConstruct
extends ScaledConstructEntity {
    public static final SpellProperty<Integer> SECOND_RANGE = SpellProperty.intProperty("second_range");

    public LightningSigilConstruct(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public LightningSigilConstruct(Level world) {
        super(EBEntities.LIGHTNING_SIGIL.get(), world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 600 && this.getCaster() == null && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(this.m_20205_() / 2.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
        for (LivingEntity target : targets) {
            if (!this.isValidTarget((Entity)target)) continue;
            Vec3 originalVec = target.m_20184_();
            if (!MagicDamageSource.causeMagicDamage(this, (Entity)target, Spells.LIGHTNING_SIGIL.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier, EBDamageSources.SHOCK)) continue;
            this.m_5496_(EBSounds.ENTITY_LIGHTNING_SIGIL_TRIGGER.get(), 1.0f, 1.0f);
            target.m_20256_(originalVec);
            double seekerRange = Spells.LIGHTNING_SIGIL.property(DefaultProperties.RANGE).floatValue();
            List<LivingEntity> secondaryTargets = EntityUtil.getLivingWithinRadius(seekerRange, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), this.m_9236_());
            int maxTargets = Spells.LIGHTNING_SIGIL.property(DefaultProperties.MAX_TARGETS);
            int hitCount = 0;
            for (LivingEntity secondary : secondaryTargets) {
                if (hitCount >= maxTargets) break;
                if (secondary == target || !this.isValidTarget((Entity)secondary)) continue;
                ++hitCount;
                if (this.m_9236_().f_46443_) {
                    ParticleBuilder.create(EBParticles.LIGHTNING).entity((Entity)target).pos(0.0, target.m_20206_() / 2.0f, 0.0).target((Entity)secondary).spawn(this.m_9236_());
                    ParticleBuilder.spawnShockParticles(this.m_9236_(), secondary.m_20185_(), secondary.m_20186_() + (double)(secondary.m_20206_() / 2.0f), secondary.m_20189_());
                    continue;
                }
                secondary.m_5496_(EBSounds.ENTITY_LIGHTNING_SIGIL_TRIGGER.get(), 1.0f, this.m_9236_().f_46441_.m_188501_() * 0.4f + 1.5f);
                secondary.m_6469_(MagicDamageSource.causeIndirectMagicDamage(this, (Entity)this.getCaster(), EBDamageSources.SHOCK), Spells.LIGHTNING_SIGIL.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier);
            }
            if (this.m_9236_().f_46443_) continue;
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188503_(15) == 0) {
            double radius = (0.5 + this.f_19796_.m_188500_() * 0.3) * (double)this.m_20205_() / 2.0;
            float angle = this.f_19796_.m_188501_() * (float)Math.PI * 2.0f;
            ParticleBuilder.create(EBParticles.SPARK).pos(this.m_20185_() + radius * (double)Mth.m_14089_((float)angle), this.m_20186_() + 0.1, this.m_20189_() + radius * (double)Mth.m_14031_((float)angle)).spawn(this.m_9236_());
        }
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return EntityDimensions.m_20395_((float)(Spells.LIGHTNING_SIGIL.property(DefaultProperties.EFFECT_RADIUS) * 2), (float)0.2f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }
}

