/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.client.particle.ParticleTornado;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TornadoConstruct
extends ScaledConstructEntity {
    private double velX;
    private double velZ;

    public TornadoConstruct(EntityType<?> type, Level world) {
        super(type, world);
    }

    public TornadoConstruct(Level world) {
        super(EBEntities.TORNADO.get(), world);
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return EntityDimensions.m_20395_((float)4.0f, (float)8.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.velX = velX;
        this.velZ = velZ;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        double radius = this.m_20205_() / 2.0f;
        if (this.f_19797_ % 120 == 1 && this.m_9236_().f_46443_) {
            ClientSpellSoundManager.playMovingSound(this, EBSounds.ENTITY_TORNADO_AMBIENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
        }
        this.m_6478_(MoverType.SELF, new Vec3(this.velX, this.m_20184_().f_82480_, this.velZ));
        BlockPos pos = this.m_20183_();
        Integer y = BlockUtil.getNearestSurface(this.m_9236_(), pos.m_6630_(3), Direction.UP, 5, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
        if (y != null && this.m_9236_().m_8055_(pos.m_6630_(y - pos.m_123342_())).m_60713_(Blocks.f_49991_)) {
            this.m_20254_(5);
        }
        if (!this.m_9236_().f_46443_) {
            List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(radius, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
            for (LivingEntity target : targets) {
                if (target instanceof Player && this.getCaster() instanceof Player || !this.isValidTarget((Entity)target)) continue;
                this.applyTornadoEffects(target);
            }
        } else {
            this.spawnParticles();
        }
    }

    private void applyTornadoEffects(LivingEntity target) {
        double velY = target.m_20184_().f_82480_;
        double dx = (this.m_20185_() - target.m_20185_() > 0.0 ? 0.5 : -0.5) - (this.m_20185_() - target.m_20185_()) * 0.125;
        double dz = (this.m_20189_() - target.m_20189_() > 0.0 ? 0.5 : -0.5) - (this.m_20189_() - target.m_20189_()) * 0.125;
        if (this.m_6060_()) {
            target.m_20254_(4);
        }
        float damage = 1.0f * this.damageMultiplier;
        MagicDamageSource.causeMagicDamage(this, (Entity)target, damage, EBDamageSources.SORCERY);
        target.m_20334_(dx, velY + 0.2, dz);
        if (target instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)target;
            sp.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target));
        }
    }

    private void spawnParticles() {
        for (int i = 1; i < 10; ++i) {
            double yPos = this.f_19796_.m_188500_() * 8.0;
            BlockPos pos = BlockPos.m_274561_((double)(this.m_20185_() - 2.0 + (double)this.f_19796_.m_188503_(4)), (double)((int)(this.m_20186_() + 3.0)), (double)(this.m_20189_() - 2.0 + (double)this.f_19796_.m_188503_(4)));
            Integer blockY = BlockUtil.getNearestSurface(this.m_9236_(), pos, Direction.UP, 5, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
            if (blockY == null) continue;
            BlockState block = this.m_9236_().m_8055_(pos.m_6630_(blockY - pos.m_123342_()));
            ParticleTornado.spawnTornadoParticle(this.m_9236_(), this.m_20185_(), this.m_20186_() + yPos, this.m_20189_(), this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos);
            if (this.f_19796_.m_188503_(3) != 0) continue;
            this.spawnAdditionalParticles(block);
        }
    }

    private void spawnAdditionalParticles(BlockState block) {
        DeferredObject<SimpleParticleType> type = null;
        if (block.m_204336_(BlockTags.f_13035_)) {
            type = EBParticles.LEAF;
        }
        if (block.m_204336_(BlockTags.f_144279_)) {
            type = EBParticles.SNOW;
        }
        if (type != null) {
            double yPos = this.f_19796_.m_188500_() * 8.0;
            ParticleBuilder.create(type).pos(this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (yPos / 3.0 + 0.5), this.m_20186_() + yPos, this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (yPos / 3.0 + 0.5)).time(40 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
        }
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.velX = tag.m_128459_("velX");
        this.velZ = tag.m_128459_("velZ");
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("velX", this.velX);
        tag.m_128347_("velZ", this.velZ);
    }
}

