/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.construct;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.necromancy.ZombieApocalypse;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class ZombieSpawnerConstruct
extends MagicConstructEntity {
    private static final double MAX_NUDGE_DISTANCE = 0.1;
    public boolean spawnHusks;
    private int spawnTimer = 10;

    public ZombieSpawnerConstruct(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ZombieSpawnerConstruct(Level level) {
        super(EBEntities.ZOMBIE_SPAWNER.get(), level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getCaster() == null) {
            return;
        }
        if (this.lifetime - this.f_19797_ > 10 && this.spawnTimer-- == 0) {
            this.m_5496_(EBSounds.ENTITY_ZOMBIE_SPAWNER_SPAWN.get(), 1.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                Husk zombie = this.spawnHusks ? new Husk(EntityType.f_20458_, this.m_9236_()) : new Zombie(EntityType.f_20501_, this.m_9236_());
                zombie.m_6593_((Component)Component.m_237110_((String)"entity.ebwizardry.minion_name", (Object[])new Object[]{this.getCaster().m_5446_(), zombie.m_5446_()}));
                MinionData data = Services.OBJECT_DATA.getMinionData((Mob)zombie);
                data.setSummoned(true);
                double nx = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.1;
                double nz = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.1;
                zombie.m_6034_(nx, this.m_20186_(), nz);
                if (this.getCaster() != null) {
                    data.setOwnerUUID(this.getCaster().m_20148_());
                }
                data.setLifetime(Spells.ZOMBIE_APOCALYPSE.property(DefaultProperties.MINION_LIFETIME));
                AttributeInstance attackAttr = zombie.m_21051_(Attributes.f_22281_);
                if (attackAttr != null) {
                    attackAttr.m_22125_(new AttributeModifier("potency", (double)(this.damageMultiplier - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
                zombie.m_21153_(zombie.m_21233_());
                zombie.f_19802_ = 30;
                this.m_9236_().m_7967_((Entity)zombie);
            }
            this.spawnTimer += Spells.ZOMBIE_APOCALYPSE.property(ZombieApocalypse.MINION_SPAWN_INTERVAL) + this.f_19796_.m_188503_(20);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)3);
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 3) {
            float colorFactor = 0.15f;
            for (double r = 1.5; r < 4.0; r += 0.2) {
                ParticleBuilder.create(EBParticles.CLOUD).color(colorFactor -= 0.02f, 0.0f, 0.0f).pos(this.m_20185_(), this.m_20186_() - 0.3, this.m_20189_()).scale(0.5f / (float)r).spin(r, 0.02 / r * (1.0 + this.m_9236_().f_46441_.m_188500_())).spawn(this.m_9236_());
            }
        }
    }

    @Override
    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("spawnTimer", this.spawnTimer);
        nbt.m_128379_("spawnHusks", this.spawnHusks);
    }

    @Override
    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.spawnTimer = nbt.m_128451_("spawnTimer");
        this.spawnHusks = nbt.m_128471_("spawnHusks");
    }
}

