/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.entity.living.AbstractWizard;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class AttackSpellGoal<T extends Mob>
extends Goal {
    private final T attacker;
    private final int baseCooldown;
    private final int continuousSpellDuration;
    private final double speed;
    private final float maxAttackDistance;
    private LivingEntity target;
    private int cooldown = -1;
    private int continuousSpellTimer;
    private int seeTime;

    public AttackSpellGoal(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.attacker.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.attacker.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.NONE, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        Services.NETWORK_HELPER.sendToTracking((Entity)this.attacker, new NPCSpellCastS2C(this.attacker.m_19879_(), this.target == null ? -1 : this.target.m_19879_(), InteractionHand.MAIN_HAND, spell, modifiers));
    }

    public void m_8037_() {
        double distanceSq = this.attacker.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean targetIsVisible = this.attacker.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.attacker.m_21573_().m_26573_();
        } else {
            this.attacker.m_21573_().m_5624_((Entity)this.target, this.speed);
        }
        this.attacker.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            --this.continuousSpellTimer;
            int currentTick = this.continuousSpellDuration - this.continuousSpellTimer;
            EntityCastContext ctx = new EntityCastContext(this.attacker.m_9236_(), (LivingEntity)this.attacker, InteractionHand.MAIN_HAND, currentTick, this.target, ((ISpellCaster)this.attacker).getModifiers());
            ((ISpellCaster)this.attacker).setSpellCounter(currentTick);
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || WizardryEventBus.getInstance().fire(new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (LivingEntity)this.attacker, ((ISpellCaster)this.attacker).getModifiers(), currentTick)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(ctx) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = ((ISpellCaster)this.attacker).getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.NONE, new SpellModifiers());
                ((ISpellCaster)this.attacker).setSpellCounter(0);
                return;
            }
            if (currentTick == 1) {
                WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (LivingEntity)this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                this.cooldown = 10;
                return;
            }
            double dx = this.target.m_20185_() - this.attacker.m_20185_();
            double dz = this.target.m_20189_() - this.attacker.m_20189_();
            ArrayList<Spell> spells = new ArrayList<Spell>(((ISpellCaster)this.attacker).getSpells());
            if (!spells.isEmpty() && !this.attacker.m_9236_().f_46443_) {
                while (!spells.isEmpty()) {
                    Spell spell = (Spell)spells.get(this.attacker.m_9236_().f_46441_.m_188503_(spells.size()));
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell != null && this.attemptCastSpell(spell, modifiers)) {
                        this.attacker.m_146922_((float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f);
                        return;
                    }
                    spells.remove(spell);
                }
            }
            this.cooldown = this.baseCooldown;
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, (LivingEntity)this.attacker, modifiers))) {
            return false;
        }
        EntityCastContext ctx = new EntityCastContext(this.attacker.m_9236_(), (LivingEntity)this.attacker, InteractionHand.MAIN_HAND, 0, this.target, modifiers);
        if (!spell.cast(ctx)) {
            return false;
        }
        if (spell.isInstantCast()) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (LivingEntity)this.attacker, modifiers));
            this.cooldown = this.baseCooldown + spell.getCooldown();
            if (!this.attacker.m_9236_().f_46443_ && spell.requiresPacket()) {
                NPCSpellCastS2C msg = new NPCSpellCastS2C(this.attacker.m_19879_(), this.target.m_19879_(), InteractionHand.MAIN_HAND, spell, modifiers);
                Services.NETWORK_HELPER.sendToTracking((Entity)this.attacker, msg);
            }
        } else {
            this.continuousSpellTimer = this.continuousSpellDuration - 1;
            this.setContinuousSpellAndNotify(spell, modifiers);
            this.attacker.m_6710_(this.target);
            T t = this.attacker;
            if (t instanceof AbstractWizard) {
                AbstractWizard wizard = (AbstractWizard)t;
                wizard.setSpellTargetId(this.target.m_19879_());
            }
        }
        return true;
    }
}

