/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.mixin.accessor.BlazeAccessor;
import com.binaris.wizardry.core.networking.s2c.NPCSpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Blaze;

public class BlazeLikeSpellAttackGoal
extends Goal {
    private final Blaze blaze;
    private final Spell spell;
    private int attackStep;
    private int attackTime;
    private int lastSeen;

    public BlazeLikeSpellAttackGoal(Blaze blaze, Spell spell) {
        this.blaze = blaze;
        this.spell = spell;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.blaze.m_5448_();
        return target != null && target.m_6084_() && this.blaze.m_6779_(target);
    }

    public void m_8056_() {
        this.attackStep = 0;
    }

    public void m_8041_() {
        ((BlazeAccessor)this.blaze).callSetCharged(false);
        this.lastSeen = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity target = this.blaze.m_5448_();
        if (target == null) {
            return;
        }
        boolean hasSight = this.blaze.m_21574_().m_148306_((Entity)target);
        this.lastSeen = hasSight ? 0 : this.lastSeen + 1;
        double distanceSq = this.blaze.m_20280_((Entity)target);
        double followDistSq = this.getFollowDistance() * this.getFollowDistance();
        if (distanceSq < 4.0) {
            if (!hasSight) {
                return;
            }
            if (this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.m_7327_((Entity)target);
            }
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            super.m_8037_();
            return;
        }
        if (distanceSq < followDistSq && hasSight) {
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = 60;
                    ((BlazeAccessor)this.blaze).callSetCharged(true);
                } else if (this.attackStep <= 4) {
                    this.attackTime = 6;
                } else {
                    this.attackTime = 100;
                    this.attackStep = 0;
                    ((BlazeAccessor)this.blaze).callSetCharged(false);
                }
                if (this.attackStep > 1) {
                    this.attemptCast(target);
                }
            }
            this.blaze.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
            super.m_8037_();
            return;
        }
        if (this.lastSeen < 5) {
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        }
        super.m_8037_();
    }

    private void attemptCast(LivingEntity target) {
        SpellModifiers modifiers = new SpellModifiers();
        EntityCastContext ctx = new EntityCastContext(this.blaze.m_9236_(), (LivingEntity)this.blaze, InteractionHand.MAIN_HAND, 0, target, modifiers);
        this.spell.cast(ctx);
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.NPC, this.spell, (LivingEntity)this.blaze, modifiers));
        if (!this.blaze.m_9236_().f_46443_ && this.spell.requiresPacket()) {
            NPCSpellCastS2C msg = new NPCSpellCastS2C(this.blaze.m_19879_(), target.m_19879_(), InteractionHand.MAIN_HAND, this.spell, modifiers);
            Services.NETWORK_HELPER.sendToTracking((Entity)this.blaze, msg);
        }
    }

    private double getFollowDistance() {
        return this.blaze.m_21133_(Attributes.f_22277_);
    }
}

