/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.core.platform.Services;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MinionFollowOwnerGoal
extends Goal {
    private final Mob minion;
    private final MinionData data;
    private final LevelReader level;
    private final float speedModifier = 1.0f;
    private final float stopDistance = 2.0f;
    private final float startDistance = 10.0f;
    private final boolean canFly = false;
    private final PathNavigation navigation;
    private LivingEntity owner;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public MinionFollowOwnerGoal(Mob minion) {
        if (!Services.OBJECT_DATA.isMinion((Entity)minion)) {
            throw new RuntimeException("MinionFollowOwnerGoal can only be used by minions!");
        }
        this.minion = minion;
        this.data = Services.OBJECT_DATA.getMinionData(this.minion);
        this.level = minion.m_9236_();
        this.navigation = minion.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(minion.m_21573_() instanceof GroundPathNavigation) && !(minion.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for MinionFollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        Player livingentity = this.data.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.minion.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.minion.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.minion.m_20159_() || this.minion.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.minion.m_21439_(BlockPathTypes.WATER);
        this.minion.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.minion.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.minion.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.minion.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.minion.m_20280_((Entity)this.owner) >= 144.0) {
                this.teleportToOwner();
            } else {
                Objects.requireNonNull(this);
                this.navigation.m_5624_((Entity)this.owner, 1.0);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.minion.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.minion.m_146908_(), this.minion.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        Objects.requireNonNull(this);
        if (blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.minion.m_20183_());
        return this.level.m_45756_((Entity)this.minion, this.minion.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.minion.m_217043_().m_188503_(max - min + 1) + min;
    }
}

