/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class RangedKitingGoal
extends Goal {
    private final PathfinderMob mob;
    private final double moveSpeed;
    private final double safeDistance;
    private final double fleeDistance;
    private final double followRange;
    private LivingEntity target;

    public RangedKitingGoal(PathfinderMob mob, double moveSpeed, double safeDistance, double fleeDistance, double followRange) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.safeDistance = safeDistance;
        this.fleeDistance = fleeDistance;
        this.followRange = followRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public RangedKitingGoal(PathfinderMob mob, double moveSpeed) {
        this(mob, moveSpeed, 12.0, 6.0, 32.0);
    }

    public boolean m_8036_() {
        double followRangeSqr;
        this.target = this.mob.m_5448_();
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        double distanceToTarget = this.mob.m_20280_((Entity)this.target);
        return distanceToTarget <= (followRangeSqr = this.followRange * this.followRange);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        double distanceToTarget = this.mob.m_20270_((Entity)this.target);
        if (distanceToTarget < this.fleeDistance) {
            this.retreatFromTarget();
        } else if (distanceToTarget > this.safeDistance) {
            this.advanceToTarget();
        } else {
            this.stopMovement();
        }
    }

    private void retreatFromTarget() {
        if (this.target == null) {
            return;
        }
        Vec3 mobPos = this.mob.m_20182_();
        Vec3 targetPos = this.target.m_20182_();
        double dx = mobPos.f_82479_ - targetPos.f_82479_;
        double dz = mobPos.f_82481_ - targetPos.f_82481_;
        double distance = Math.sqrt(dx * dx + dz * dz);
        if (distance > 0.0) {
            dx /= distance;
            dz /= distance;
        }
        this.mob.m_20334_(this.mob.m_20184_().m_7096_() + dx * this.moveSpeed * 0.1, this.mob.m_20184_().m_7098_(), this.mob.m_20184_().m_7094_() + dz * this.moveSpeed * 0.1);
    }

    private void advanceToTarget() {
        if (this.target == null) {
            return;
        }
        Vec3 mobPos = this.mob.m_20182_();
        Vec3 targetPos = this.target.m_20182_();
        double dx = targetPos.f_82479_ - mobPos.f_82479_;
        double dz = targetPos.f_82481_ - mobPos.f_82481_;
        double distance = Math.sqrt(dx * dx + dz * dz);
        if (distance > 0.0) {
            dx /= distance;
            dz /= distance;
        }
        this.mob.m_20334_(this.mob.m_20184_().m_7096_() + dx * this.moveSpeed * 0.1, this.mob.m_20184_().m_7098_(), this.mob.m_20184_().m_7094_() + dz * this.moveSpeed * 0.1);
    }

    private void stopMovement() {
        if (this.target == null) {
            return;
        }
        this.mob.m_20334_(this.mob.m_20184_().m_7096_() * 0.9, this.mob.m_20184_().m_7098_(), this.mob.m_20184_().m_7094_() * 0.9);
    }
}

