/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.living;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.content.entity.goal.AttackSpellBasicGoal;
import com.binaris.wizardry.content.entity.goal.HardLookAtTargetGoal;
import com.binaris.wizardry.content.entity.goal.RangedKitingGoal;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWizard
extends PathfinderMob
implements ISpellCaster {
    private static final EntityDataAccessor<Integer> HEAL_COOLDOWN = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> CONTINUOUS_SPELL = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> SPELL_COUNTER = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TARGET_ID = SynchedEntityData.m_135353_(AbstractWizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected List<Spell> spells = new ArrayList<Spell>(4);

    public AbstractWizard(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedKitingGoal(this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new HardLookAtTargetGoal(this, 10.0f, 10.0f));
        this.f_21345_.m_25352_(4, new AttackSpellBasicGoal<AbstractWizard>(this, 14.0f, 30, 50));
        this.f_21345_.m_25352_(5, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(6, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, AbstractWizard.class, 5.0f, 0.02f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{AbstractWizard.class}));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 0, false, true, entity -> entity != null && !entity.m_20145_() && entity instanceof Enemy));
    }

    public void m_8107_() {
        super.m_8107_();
        this.handleContinuousSpellOnClient();
        this.handleSelfHealing();
    }

    private void handleContinuousSpellOnClient() {
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Spell continuousSpell = this.getContinuousSpell();
        int spellCounter = this.getSpellCounter();
        if (continuousSpell == Spells.NONE || spellCounter <= 0) {
            return;
        }
        int targetId = this.getSpellTargetId();
        LivingEntity target = null;
        if (targetId != -1 && (entity = this.m_9236_().m_6815_(targetId)) instanceof LivingEntity) {
            LivingEntity livingEntity;
            target = livingEntity = (LivingEntity)entity;
        }
        if (target != null) {
            EntityCastContext ctx = new EntityCastContext(this.m_9236_(), (LivingEntity)this, InteractionHand.MAIN_HAND, spellCounter, target, this.getModifiers());
            continuousSpell.cast(ctx);
        }
    }

    private void handleSelfHealing() {
        int healCooldown = this.getHealCooldown();
        if (this.shouldStartHealing()) {
            this.m_5634_(this.getElement() == Elements.HEALING ? 8.0f : 4.0f);
            this.setHealCooldown(-1);
            return;
        }
        if (healCooldown == -1 && !this.m_21224_()) {
            if (this.m_9236_().f_46443_) {
                ParticleBuilder.spawnHealParticles(this.m_9236_(), (LivingEntity)this);
                return;
            }
            if (this.m_21223_() < 10.0f) {
                this.setHealCooldown(150);
            } else {
                this.setHealCooldown(400);
            }
            SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(Spells.HEAL.getLocation().m_135827_(), "spell." + Spells.HEAL.getLocation().m_135815_()));
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.PLAYERS, Spells.HEAL.getVolume(), Spells.HEAL.getPitch() + Spells.HEAL.getPitchVariation() * (this.m_9236_().f_46441_.m_188501_() - 0.5f));
        }
        if (healCooldown > 0) {
            this.setHealCooldown(healCooldown - 1);
        }
    }

    private boolean shouldStartHealing() {
        return this.getHealCooldown() == 0 && this.m_21223_() < this.m_21233_() && this.m_21223_() > 0.0f && !this.m_21023_(EBMobEffects.ARCANE_JAMMER.get());
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setTextureIndex(this.f_19796_.m_188503_(6));
        if (((String)this.f_19804_.m_135370_(ELEMENT)).isEmpty()) {
            Element element = this.chooseElement();
            this.setElement(element);
        }
        this.equipArmorAndDisableDrops(this.getElement());
        this.spells.add(Spells.MAGIC_MISSILE);
        SpellTier maxTier = EntityUtil.populateSpells(this.spells, this.getElement(), false, 3, this.f_19796_);
        this.prepareWandWithSpells(this.getElement(), maxTier);
        this.setHealCooldown(50);
        return super.m_6518_(level, difficulty, mobSpawnType, spawnData, tag);
    }

    private Element chooseElement() {
        if (this.f_19796_.m_188499_()) {
            ArrayList<Element> elements = new ArrayList<Element>(Services.REGISTRY_UTIL.getElements());
            elements.remove(Elements.MAGIC);
            return (Element)elements.get(this.f_19796_.m_188503_(elements.size()));
        }
        return Elements.MAGIC;
    }

    private void equipArmorAndDisableDrops(Element element) {
        for (EquipmentSlot slot : InventoryUtil.ARMOR_SLOTS) {
            this.m_8061_(slot, new ItemStack((ItemLike)RegistryUtils.getArmor(WizardArmorType.WIZARD, element, slot)));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.m_21409_(slot, 0.0f);
        }
    }

    private void prepareWandWithSpells(Element element, SpellTier maxTier) {
        ArrayList<Spell> list = new ArrayList<Spell>(this.spells);
        list.add(Spells.HEAL);
        Item item = RegistryUtils.getWand(maxTier, element);
        if (item == Items.f_41852_ || !(item instanceof WandItem)) {
            EBLogger.warn("Failed to create wand for wizard with element {} and max tier {}. Defaulting to apprentice wand.", element.getName(), maxTier);
            item = EBItems.APPRENTICE_WAND.get();
        }
        ItemStack wand = new ItemStack((ItemLike)item);
        Spell[] spellsArray = list.toArray(new Spell[0]);
        WandHelper.setSpells(wand, Arrays.asList(spellsArray));
        this.m_8061_(EquipmentSlot.MAINHAND, wand);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_7639_() instanceof Player) {
            EBAdvancementTriggers.ANGER_WIZARD.triggerFor((Player)source.m_7639_());
        }
        return super.m_6469_(source, damage);
    }

    @NotNull
    public Component m_5446_() {
        if (this.m_8077_() || this.getElement() == null) {
            return super.m_5446_();
        }
        return this.getElement().getWizardName();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAL_COOLDOWN, (Object)-1);
        this.f_19804_.m_135372_(ELEMENT, (Object)"");
        this.f_19804_.m_135372_(CONTINUOUS_SPELL, (Object)Spells.NONE.getLocation().toString());
        this.f_19804_.m_135372_(SPELL_COUNTER, (Object)0);
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
        this.f_19804_.m_135372_(SPELL_TARGET_ID, (Object)-1);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        Element element = this.getElement();
        if (element != null) {
            nbt.m_128359_("element", element.getLocation().toString());
        }
        nbt.m_128405_("skin", this.getTextureIndex());
        NBTExtras.storeTagSafely(nbt, "spells", (Tag)NBTExtras.listToTag(this.spells, spell -> StringTag.m_129297_((String)spell.getLocation().toString())));
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        Element element = Services.REGISTRY_UTIL.getElement(ResourceLocation.m_135820_((String)nbt.m_128461_("element")));
        if (element != null) {
            this.setElement(element);
        }
        this.setTextureIndex(nbt.m_128451_("skin"));
        this.spells = (List)NBTExtras.tagToList(nbt.m_128437_("spells", 8), tag -> Services.REGISTRY_UTIL.getSpell(ResourceLocation.m_135820_((String)tag.m_7916_())));
    }

    private int getHealCooldown() {
        return (Integer)this.f_19804_.m_135370_(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.f_19804_.m_135381_(HEAL_COOLDOWN, (Object)cooldown);
    }

    @Nullable
    public Element getElement() {
        return Services.REGISTRY_UTIL.getElement(ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(ELEMENT))));
    }

    public void setElement(Element element) {
        this.f_19804_.m_135381_(ELEMENT, (Object)element.getLocation().toString());
    }

    public int getTextureIndex() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)index);
    }

    @Override
    @NotNull
    public List<Spell> getSpells() {
        return this.spells;
    }

    public void setSpells(List<Spell> spells) {
        this.spells = spells;
    }

    @Override
    @NotNull
    public Spell getContinuousSpell() {
        Spell spell = Services.REGISTRY_UTIL.getSpell(ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(CONTINUOUS_SPELL))));
        return spell == null ? Spells.NONE : spell;
    }

    @Override
    public void setContinuousSpell(Spell spell) {
        this.f_19804_.m_135381_(CONTINUOUS_SPELL, (Object)spell.getLocation().toString());
    }

    @Override
    public int getSpellCounter() {
        return (Integer)this.f_19804_.m_135370_(SPELL_COUNTER);
    }

    @Override
    public void setSpellCounter(int count) {
        this.f_19804_.m_135381_(SPELL_COUNTER, (Object)count);
    }

    public int getSpellTargetId() {
        return (Integer)this.f_19804_.m_135370_(SPELL_TARGET_ID);
    }

    public void setSpellTargetId(int targetId) {
        this.f_19804_.m_135381_(SPELL_TARGET_ID, (Object)targetId);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }
}

