/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.living;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Remnant
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Remnant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(Remnant.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    private BlockPos boundOrigin;
    private ResourceLocation lootTable;

    public Remnant(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new RemnantMoveControl(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RemnantChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new RemnantRandomMoveGoal());
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> this.isAttacking()));
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Vec3 centre = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        Element element = Services.REGISTRY_UTIL.getElement(ResourceLocation.m_135820_((String)this.getElement()));
        if (element == null) {
            return;
        }
        int[] colours = element.getColors();
        double r = this.m_20206_() / 3.0f;
        double x = r * (this.f_19796_.m_188500_() * 2.0 - 1.0);
        double y = r * (this.f_19796_.m_188500_() * 2.0 - 1.0);
        double z = r * (this.f_19796_.m_188500_() * 2.0 - 1.0);
        if (this.f_20919_ > 0) {
            for (int i = 0; i < 8; ++i) {
                ParticleBuilder.create(EBParticles.DUST, this.f_19796_, centre.f_82479_ + x, centre.f_82480_ + y, centre.f_82481_ + z, 0.1, true).time(12).color(colours[1]).fade(colours[2]).spawn(this.m_9236_());
            }
        } else {
            ParticleBuilder.create(EBParticles.DUST).pos(centre.f_82479_ + x, centre.f_82480_ + y, centre.f_82481_ + z).velocity(x * -0.03, 0.02, z * -0.03).time(24 + this.f_19796_.m_188503_(8)).color(colours[1]).fade(colours[2]).spawn(this.m_9236_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ELEMENT, (Object)Elements.FIRE.getLocation().toString());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Element", this.getElement());
        if (this.boundOrigin != null) {
            compound.m_128365_("BoundOrigin", (Tag)NbtUtils.m_129224_((BlockPos)this.boundOrigin));
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setElement(compound.m_128461_("Element"));
        if (compound.m_128441_("BoundOrigin")) {
            this.boundOrigin = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BoundOrigin"));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        ArrayList<Element> elements = new ArrayList<Element>(Services.REGISTRY_UTIL.getElements().stream().toList());
        elements.remove(Elements.MAGIC);
        this.setElement(((Element)elements.get(this.f_19796_.m_188503_(elements.size()))).getLocation().toString());
        this.setBoundOrigin(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public String getElement() {
        return (String)this.f_19804_.m_135370_(ELEMENT);
    }

    public void setElement(String element) {
        this.f_19804_.m_135381_(ELEMENT, (Object)element);
        this.lootTable = WizardryMainMod.location("entities/remnant/" + ResourceLocation.m_135820_((String)element).m_135815_());
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return this.lootTable != null ? this.lootTable : super.m_7582_();
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOrigin) {
        this.boundOrigin = boundOrigin;
    }

    public int m_213860_() {
        return 8;
    }

    protected SoundEvent m_7515_() {
        return EBSounds.ENTITY_REMNANT_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return EBSounds.ENTITY_REMNANT_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return EBSounds.ENTITY_REMNANT_HURT.get();
    }

    class RemnantMoveControl
    extends MoveControl {
        public RemnantMoveControl(Remnant remnant) {
            super((Mob)remnant);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - Remnant.this.m_20185_(), this.f_24976_ - Remnant.this.m_20186_(), this.f_24977_ - Remnant.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < Remnant.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    Remnant.this.m_20256_(Remnant.this.m_20184_().m_82490_(0.5));
                } else {
                    Remnant.this.m_20256_(Remnant.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (Remnant.this.m_5448_() == null) {
                        Vec3 vec31 = Remnant.this.m_20184_();
                        Remnant.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        Remnant.this.f_20883_ = Remnant.this.m_146908_();
                    } else {
                        double d2 = Remnant.this.m_5448_().m_20185_() - Remnant.this.m_20185_();
                        double d1 = Remnant.this.m_5448_().m_20189_() - Remnant.this.m_20189_();
                        Remnant.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        Remnant.this.f_20883_ = Remnant.this.m_146908_();
                    }
                }
            }
        }
    }

    class RemnantChargeAttackGoal
    extends Goal {
        public RemnantChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Remnant.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !Remnant.this.m_21566_().m_24995_() && Remnant.this.f_19796_.m_188503_(RemnantChargeAttackGoal.m_186073_((int)7)) == 0) {
                return Remnant.this.m_20280_((Entity)livingentity) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Remnant.this.m_21566_().m_24995_() && Remnant.this.isAttacking() && Remnant.this.m_5448_() != null && Remnant.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = Remnant.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                Remnant.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            Remnant.this.setAttacking(true);
            Remnant.this.m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            Remnant.this.setAttacking(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = Remnant.this.m_5448_();
            if (livingentity != null) {
                if (Remnant.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    Remnant.this.m_7327_((Entity)livingentity);
                    Remnant.this.setAttacking(false);
                } else {
                    double d0 = Remnant.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        Remnant.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class RemnantRandomMoveGoal
    extends Goal {
        public RemnantRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Remnant.this.m_21566_().m_24995_() && Remnant.this.f_19796_.m_188503_(RemnantRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Remnant.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = Remnant.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Remnant.this.f_19796_.m_188503_(15) - 7, Remnant.this.f_19796_.m_188503_(11) - 5, Remnant.this.f_19796_.m_188503_(15) - 7);
                if (!Remnant.this.m_9236_().m_46859_(blockpos1)) continue;
                Remnant.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (Remnant.this.m_5448_() != null) break;
                Remnant.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

