/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.living;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.entity.goal.WizardLookAtTradePlayer;
import com.binaris.wizardry.content.entity.goal.WizardTradeGoal;
import com.binaris.wizardry.content.entity.living.AbstractWizard;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wizard
extends AbstractWizard
implements Npc,
Merchant {
    private static final int[] XP_PER_LEVEL = new int[]{0, 10, 70, 150, 250};
    private static final int MAX_LEVEL = 5;
    private static final int MAX_TRADES = 2;
    private MerchantOffers trades;
    @Nullable
    private Player customer;
    private int timeUntilReset;
    private int wizardXp;
    private int wizardLevel = 1;

    public Wizard(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    private static int getXpForTier(SpellTier tier) {
        if (tier == SpellTiers.NOVICE) {
            return 2;
        }
        if (tier == SpellTiers.APPRENTICE) {
            return 10;
        }
        if (tier == SpellTiers.ADVANCED) {
            return 20;
        }
        return 50;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new WizardTradeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WizardLookAtTradePlayer(this));
    }

    public void m_7713_(@NotNull ItemStack stack) {
        if (this.m_9236_().f_46443_ || this.f_21363_ <= -this.m_8100_() + 20) {
            return;
        }
        this.f_21363_ = -this.m_8100_();
        SoundEvent sound = stack.m_41619_() ? EBSounds.ENTITY_WIZARD_NO.get() : (WizardryMainMod.IS_THE_SEASON ? EBSounds.ENTITY_WIZARD_HOHOHO.get() : EBSounds.ENTITY_WIZARD_YES.get());
        this.m_5496_(sound, this.m_6121_(), this.m_6100_());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isTrading() || this.timeUntilReset < 0) {
            return;
        }
        --this.timeUntilReset;
        if (this.timeUntilReset > 0) {
            return;
        }
        if (this.trades != null) {
            this.trades.stream().filter(MerchantOffer::m_45380_).forEach(MerchantOffer::m_45372_);
        }
        this.timeUntilReset = -1;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_6084_() && !this.isTrading() && !this.m_6162_() && !player.m_6144_() && this.m_5448_() != player) {
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.wizardLevel);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.trades != null) {
            nbt.m_128365_("trades", (Tag)this.trades.m_45388_());
        }
        nbt.m_128405_("wizardXp", this.wizardXp);
        nbt.m_128405_("wizardLevel", this.wizardLevel);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("trades")) {
            this.trades = new MerchantOffers(nbt.m_128469_("trades"));
        }
        this.wizardXp = nbt.m_128451_("wizardXp");
        this.wizardLevel = nbt.m_128451_("wizardLevel");
        if (this.wizardLevel == 0) {
            this.wizardLevel = 1;
        }
    }

    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(EBSounds.ENTITY_WIZARD_YES.get(), this.m_6121_(), this.m_6100_());
        int xpGain = merchantOffer.m_45379_();
        if (EBAccessoriesIntegration.isEquipped(this.customer, EBItems.CHARM_HAGGLER.get())) {
            xpGain *= 2;
        }
        this.wizardXp += xpGain;
        this.tryLevelUp();
        if (this.f_19796_.m_188503_(5) == 0 || EBAccessoriesIntegration.isEquipped(this.customer, EBItems.CHARM_HAGGLER.get())) {
            this.timeUntilReset = 40;
        }
        if (this.m_7962_() == null) {
            return;
        }
        EBAdvancementTriggers.WIZARD_TRADE.triggerFor(this.m_7962_());
        if (!(merchantOffer.m_45368_().m_41720_() instanceof SpellBookItem)) {
            return;
        }
        Spell spell = SpellUtil.getSpell(merchantOffer.m_45368_());
        if (spell.getTier() == SpellTiers.MASTER) {
            EBAdvancementTriggers.BUY_MASTER_SPELL.triggerFor(this.m_7962_());
        }
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(this.m_7962_());
        if (WizardryEventBus.getInstance().fire(new EBDiscoverSpellEvent(this.m_7962_(), spell, EBDiscoverSpellEvent.Source.PURCHASE))) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            data.discoverSpell(spell);
            if (!this.m_7962_().m_7500_()) {
                EntityUtil.playSoundAtPlayer(this.m_7962_(), EBSounds.MISC_DISCOVER_SPELL.get(), 1.25f, 1.0f);
                this.m_7962_().m_213846_((Component)Component.m_237110_((String)"spell.discover", (Object[])new Object[]{spell.getDescriptionFormatted()}));
            }
        }
    }

    private void tryLevelUp() {
        int nextLevel = Mth.m_14045_((int)(this.wizardLevel + 1), (int)1, (int)5);
        if (nextLevel > this.wizardLevel && this.wizardXp >= XP_PER_LEVEL[nextLevel - 1]) {
            this.wizardLevel = nextLevel;
            this.updateTrades();
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 1));
                this.m_9236_().m_7605_((Entity)this, (byte)14);
            }
        }
    }

    @NotNull
    public MerchantOffers m_6616_() {
        if (this.trades == null) {
            this.trades = new MerchantOffers();
            this.updateTrades();
        }
        return this.trades;
    }

    private void updateTrades() {
        if (this.trades == null) {
            this.trades = new MerchantOffers();
        }
        switch (this.wizardLevel) {
            case 1: {
                this.addNoviceTrades();
                break;
            }
            case 2: {
                this.addApprenticeTrades();
                break;
            }
            case 3: {
                this.addAdvancedTrades();
                break;
            }
            case 4: 
            case 5: {
                this.addMasterTrades();
            }
        }
    }

    private void addNoviceTrades() {
        ArrayList<MerchantOffer> possibleTrades = new ArrayList<MerchantOffer>();
        this.trades.add((Object)this.createTrade(new ItemStack((ItemLike)EBItems.SPELL_BOOK.get()), ItemStack.f_41583_, new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 4), 12, 2, 0.05f));
        if (this.getElement() != null && this.getElement() != Elements.MAGIC) {
            possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 3 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get()), new ItemStack((ItemLike)RegistryUtils.getCrystal(this.getElement())), 12, 5, 0.05f));
        }
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 6 + this.f_19796_.m_188503_(5)), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 4 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)RegistryUtils.getWand(SpellTiers.NOVICE, this.getElement())), 3, 10, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.NOVICE, 1 + this.f_19796_.m_188503_(4), 2 + this.f_19796_.m_188503_(2)));
        possibleTrades.add(this.createSpellTrade(SpellTiers.NOVICE, 1 + this.f_19796_.m_188503_(4), 2 + this.f_19796_.m_188503_(2)));
        this.addRandomTrades(possibleTrades);
    }

    private void addApprenticeTrades() {
        ArrayList<MerchantOffer> possibleTrades = new ArrayList<MerchantOffer>();
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 13 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 6 + this.f_19796_.m_188503_(5)), new ItemStack((ItemLike)RegistryUtils.getWand(SpellTiers.APPRENTICE, this.getElement())), 3, 20, 0.2f));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 14 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)Items.f_42516_, 4 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)Wizard.getRandomUpgrade(this.f_19796_)), 12, 10, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.APPRENTICE, 7 + this.f_19796_.m_188503_(4), 6 + this.f_19796_.m_188503_(5)));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 3 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 3 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)EBItems.MAGIC_SILK.get()), 12, 10, 0.2f));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 10 + this.f_19796_.m_188503_(3)), new ItemStack((ItemLike)Items.f_42517_), SpellUtil.arcaneTomeItem(SpellTiers.APPRENTICE), 3, 30, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private void addAdvancedTrades() {
        ArrayList<MerchantOffer> possibleTrades = new ArrayList<MerchantOffer>();
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 14 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)Items.f_42516_, 4 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)Wizard.getRandomUpgrade(this.f_19796_)), 12, 15, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.ADVANCED, 12 + this.f_19796_.m_188503_(5), 8 + this.f_19796_.m_188503_(8)));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 14 + this.f_19796_.m_188503_(3)), new ItemStack((ItemLike)Items.f_42517_), SpellUtil.arcaneTomeItem(SpellTiers.ADVANCED), 3, 30, 0.2f));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 13 + this.f_19796_.m_188503_(4)), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), 8 + this.f_19796_.m_188503_(3)), new ItemStack((ItemLike)RegistryUtils.getArmor(WizardArmorType.WIZARD, this.getElement(), this.f_19796_)), 3, 20, 0.2f));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 14 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)EBItems.BLANK_SCROLL.get()), new ItemStack((ItemLike)EBItems.IDENTIFICATION_SCROLL.get()), 3, 30, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private void addMasterTrades() {
        ArrayList<MerchantOffer> possibleTrades = new ArrayList<MerchantOffer>();
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 14 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)Items.f_42516_, 4 + this.f_19796_.m_188503_(2)), new ItemStack((ItemLike)Wizard.getRandomUpgrade(this.f_19796_)), 12, 20, 0.2f));
        possibleTrades.add(this.createSpellTrade(SpellTiers.MASTER, 20 + this.f_19796_.m_188503_(6), 15 + this.f_19796_.m_188503_(6)));
        possibleTrades.add(this.createTrade(new ItemStack((ItemLike)Items.f_42417_, 20 + this.f_19796_.m_188503_(6)), new ItemStack((ItemLike)EBItems.ASTRAL_DIAMOND.get()), SpellUtil.arcaneTomeItem(SpellTiers.MASTER), 3, 50, 0.2f));
        this.addRandomTrades(possibleTrades);
    }

    private MerchantOffer createSpellTrade(SpellTier tier, int goldAmount, int crystalAmount) {
        List<Spell> spells = SpellUtil.getSpells(s -> s.getTier() == tier);
        if (spells.isEmpty()) {
            return null;
        }
        Spell spell = spells.get(this.f_19796_.m_188503_(spells.size()));
        ItemStack spellBook = new ItemStack((ItemLike)EBItems.SPELL_BOOK.get());
        SpellUtil.setSpell(spellBook, spell);
        int xp = Wizard.getXpForTier(tier);
        return this.createTrade(new ItemStack((ItemLike)Items.f_42417_, goldAmount), new ItemStack((ItemLike)EBItems.MAGIC_CRYSTAL.get(), crystalAmount), spellBook, 7, xp, 0.2f);
    }

    private void addRandomTrades(List<MerchantOffer> possibleTrades) {
        Collections.shuffle(possibleTrades);
        int tradesToAdd = Math.min(2, possibleTrades.size());
        this.trades.addAll(possibleTrades.subList(0, tradesToAdd));
    }

    public static Item getRandomUpgrade(RandomSource random) {
        int index = random.m_188503_(WandUpgrades.getSpecialUpgrades().size());
        return (Item)WandUpgrades.getSpecialUpgrades().stream().toList().get(index);
    }

    private MerchantOffer createTrade(ItemStack cost1, ItemStack cost2, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        return new MerchantOffer(cost1, cost2, result, maxUses, xp, priceMultiplier);
    }

    protected SoundEvent m_7515_() {
        if (WizardryMainMod.IS_THE_SEASON) {
            return EBSounds.ENTITY_WIZARD_HOHOHO.get();
        }
        return this.isTrading() ? EBSounds.ENTITY_WIZARD_TRADING.get() : EBSounds.ENTITY_WIZARD_AMBIENT.get();
    }

    public boolean isTrading() {
        return this.m_7962_() != null;
    }

    public Player m_7962_() {
        return this.customer;
    }

    public void m_7189_(Player player) {
        this.customer = player;
    }

    @NotNull
    public SoundEvent m_7596_() {
        return EBSounds.ENTITY_WIZARD_YES.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return EBSounds.ENTITY_WIZARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return EBSounds.ENTITY_WIZARD_DEATH.get();
    }

    public void m_6255_(@NotNull MerchantOffers offers) {
        this.trades = offers;
    }

    public int m_7809_() {
        return this.wizardXp;
    }

    public void m_6621_(int xp) {
        this.wizardXp = xp;
    }

    public boolean m_7826_() {
        return true;
    }

    public boolean m_7862_() {
        return true;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }
}

