/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DarknessOrbEntity
extends MagicProjectileEntity {
    public DarknessOrbEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public DarknessOrbEntity(Level world) {
        super(EBEntities.DARKNESS_ORB.get(), world);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        LivingEntity livingEntity;
        super.m_5790_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = result.m_82443_();
        if (!(entity instanceof LivingEntity) || MagicDamageSource.isEntityImmune(EBDamageSources.WITHER, (Entity)(livingEntity = (LivingEntity)entity))) {
            return;
        }
        float damage = Spells.DARKNESS_ORB.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
        MagicDamageSource.causeMagicDamage((Entity)this, (Entity)livingEntity, damage, EBDamageSources.WITHER);
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, Spells.DARKNESS_ORB.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.DARKNESS_ORB.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        this.m_5496_(EBSounds.ENTITY_DARKNESS_ORB_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(this.m_20184_().f_82479_ / 0.99, this.m_20184_().f_82480_ / 0.99, this.m_20184_().f_82481_ / 0.99);
        if (this.m_9236_().f_46443_ && this.f_19797_ > 2) {
            float brightness = this.f_19796_.m_188501_() * 0.2f;
            ParticleBuilder.create(EBParticles.SPARKLE, (Entity)this).time(20 + this.f_19796_.m_188503_(10)).color(brightness, 0.0f, brightness).spawn(this.m_9236_());
            ParticleBuilder.create(EBParticles.DARK_MAGIC, (Entity)this).color(0.1f, 0.0f, 0.0f).spawn(this.m_9236_());
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public int getLifeTime() {
        return 60;
    }

    @NotNull
    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }
}

