/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DartEntity
extends MagicArrowEntity {
    public DartEntity(EntityType<DartEntity> entityDartEntityType, Level world) {
        super(entityDartEntityType, world);
    }

    public DartEntity(Level world) {
        super(EBEntities.DART.get(), world);
    }

    @Override
    public double getDamage() {
        return Spells.DART.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/dart.png");
    }

    @Override
    public boolean doDeceleration() {
        return true;
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.POISON;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.m_9236_().f_46443_) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, Spells.DART.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.DART.property(DefaultProperties.EFFECT_STRENGTH).intValue(), false, false));
            }
        }
        super.m_5790_(hitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.m_5496_(EBSounds.ENTITY_DART_HIT_BLOCK.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        super.m_8060_(blockHitResult);
    }

    @Override
    public void ticksInAir() {
        if (this.m_9236_().m_5776_() && this.f_19797_ > 1) {
            ParticleBuilder.create(EBParticles.LEAF, (Entity)this).time(10 + this.f_19796_.m_188503_(5)).spawn(this.m_9236_());
        }
    }

    @Override
    public void tickInGround() {
        if (this.ticksInGround > 60) {
            this.m_146870_();
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

