/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class FireBoltEntity
extends MagicProjectileEntity {
    public FireBoltEntity(Level world) {
        super(EBEntities.FIRE_BOLT.get(), world);
    }

    public FireBoltEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.m_82443_();
            float damage = Spells.FIREBOLT.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            if (!MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, entity)) {
                MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.FIRE);
                entity.m_20254_(Spells.FIREBOLT.property(DefaultProperties.EFFECT_DURATION).intValue());
            }
        }
        this.m_5496_(EBSounds.ENTITY_FIREBOLT_HIT.get(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.3f);
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + (double)this.f_19796_.m_188501_() - 0.5, this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1) {
            ParticleBuilder.create(EBParticles.MAGIC_FIRE, (Entity)this).time(14).spawn(this.m_9236_());
            if (this.f_19797_ > 1) {
                double x = this.f_19854_ - this.m_20184_().f_82479_ / 2.0 + (double)this.f_19796_.m_188501_() * 0.2 - 0.1;
                double y = this.f_19855_ + (double)(this.m_20206_() / 2.0f) - this.m_20184_().f_82480_ / 2.0 + (double)this.f_19796_.m_188501_() * 0.2 - 0.1;
                double z = this.f_19856_ - this.m_20184_().f_82481_ / 2.0 + (double)this.f_19796_.m_188501_() * 0.2 - 0.1;
                ParticleBuilder.create(EBParticles.MAGIC_FIRE).pos(x, y, z).time(14).spawn(this.m_9236_());
            }
        }
    }

    @NotNull
    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }

    @Override
    public int getLifeTime() {
        return 6;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }
}

