/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class FireBombEntity
extends BombEntity {
    public FireBombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public FireBombEntity(LivingEntity livingEntity, Level world) {
        super(EBEntities.FIRE_BOMB.get(), livingEntity, world);
    }

    public FireBombEntity(Level world) {
        super(EBEntities.FIRE_BOMB.get(), world);
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.m_82443_();
            float damage = Spells.FIREBOMB.property(DefaultProperties.DAMAGE).floatValue();
            MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.FIRE);
        } else if (hitResult instanceof BlockHitResult) {
            List<LivingEntity> livingEntities = EntityUtil.getLivingEntitiesInRange(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), Spells.FIREBOMB.property(DefaultProperties.EFFECT_RADIUS).intValue());
            for (LivingEntity entity : livingEntities) {
                MagicDamageSource.causeMagicDamage((Entity)this, (Entity)entity, Spells.FIREBOMB.property(DefaultProperties.SPLASH_DAMAGE).floatValue() * this.blastMultiplier, EBDamageSources.FIRE);
                if (MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (Entity)entity)) continue;
                entity.m_20254_(Spells.FIREBOMB.property(DefaultProperties.EFFECT_DURATION).intValue());
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(EBSounds.ENTITY_FIREBOMB_SMASH.get(), 1.5f, this.f_19796_.m_188501_() * 0.4f + 0.6f);
            this.m_5496_(EBSounds.ENTITY_FIREBOMB_FIRE.get(), 1.0f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public void m_7822_(byte b) {
        if (b == 3) {
            ParticleBuilder.create(EBParticles.FLASH).pos(this.m_20182_()).scale(5.0f * this.blastMultiplier).color(1.0f, 0.6f, 0.0f).spawn(this.m_9236_());
            int i = 0;
            while ((float)i < 60.0f * this.blastMultiplier) {
                ParticleBuilder.create(EBParticles.MAGIC_FIRE, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_, this.f_19856_, 2.0f * this.blastMultiplier, false).time(10 + this.f_19796_.m_188503_(4)).scale(1.0f + this.f_19796_.m_188501_()).spawn(this.m_9236_());
                ParticleBuilder.create(EBParticles.DARK_MAGIC, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_, this.f_19856_, 2.0f * this.blastMultiplier, false).color(1.0f, 0.2f + this.f_19796_.m_188501_() * 0.4f, 0.0f).spawn(this.m_9236_());
                ++i;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_19854_, this.f_19855_, this.f_19856_, 0.0, 0.0, 0.0);
        }
    }

    public int m_20094_() {
        return -1;
    }

    @NotNull
    protected Item m_7881_() {
        return EBItems.FIREBOMB.get();
    }
}

