/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FlamecatcherArrow
extends MagicArrowEntity {
    public static final float SPEED = 3.0f;

    public FlamecatcherArrow(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public FlamecatcherArrow(Level world) {
        super(EBEntities.FLAME_CATCHER_ARROW.get(), world);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/flamecatcher_arrow.png");
    }

    @Override
    public double getDamage() {
        return Spells.FLAMECATCHER.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return (int)(Spells.FLAMECATCHER.property(DefaultProperties.RANGE).floatValue() * 3.0f);
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (Entity)livingEntity)) {
                livingEntity.m_20254_(15);
            }
            this.m_5496_(EBSounds.ENTITY_FLAMECATCHER_ARROW_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_9236_().f_46443_) {
                ParticleBuilder.create(EBParticles.FLASH).pos(this.m_20185_(), this.m_20186_(), this.m_20189_()).color(16739584).spawn(this.m_9236_());
            }
        }
        super.m_5790_(hitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_().f_46443_) {
            Vec3 vec = blockHitResult.m_82450_().m_82549_(new Vec3((double)blockHitResult.m_82434_().m_122429_(), (double)blockHitResult.m_82434_().m_122430_(), (double)blockHitResult.m_82434_().m_122431_()).m_82490_(0.15));
            ParticleBuilder.create(EBParticles.FLASH).pos(vec).color(16739584).fade(0.85f, 0.5f, 0.8f).spawn(this.m_9236_());
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public void ticksInAir() {
        if (this.m_9236_().f_46443_) {
            ParticleBuilder.create(EBParticles.MAGIC_FIRE, this.m_9236_().m_213780_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.03, false).time(20 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
            if (this.getLifetime() > 1) {
                double x = this.m_20185_() - this.m_20184_().f_82479_ / 2.0;
                double y = this.m_20186_() - this.m_20184_().f_82480_ / 2.0;
                double z = this.m_20189_() - this.m_20184_().f_82481_ / 2.0;
                ParticleBuilder.create(EBParticles.MAGIC_FIRE, this.m_9236_().m_213780_(), x, y, z, 0.03, false).time(20 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
            }
        }
        super.ticksInAir();
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.FIRE;
    }
}

