/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ForceArrow
extends MagicArrowEntity {
    private int mana = 0;

    public ForceArrow(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public ForceArrow(Level world) {
        super(EBEntities.FORCE_ARROW.get(), world);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        this.m_5496_(EBSounds.ENTITY_FORCE_ARROW_HIT.get(), 1.0f, 1.0f);
        if (this.m_9236_().m_5776_()) {
            ParticleBuilder.create(EBParticles.FLASH).pos(this.m_20185_(), this.m_20186_(), this.m_20189_()).scale(1.3f).color(0.75f, 1.0f, 0.85f).spawn(this.m_9236_());
        }
        super.m_5790_(hitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.m_5496_(EBSounds.ENTITY_FORCE_ARROW_HIT.get(), 1.0f, 1.0f);
        super.m_8060_(blockHitResult);
        if (this.m_9236_().m_5776_()) {
            Vec3 pos = blockHitResult.m_82450_().m_82549_(Vec3.m_82528_((Vec3i)blockHitResult.m_82434_().m_122436_()).m_82490_(0.15));
            ParticleBuilder.create(EBParticles.FLASH).pos(pos).scale(1.6f).color(0.75f, 1.0f, 0.85f).spawn(this.m_9236_());
        }
    }

    @Override
    public void m_8119_() {
        if (this.getLifetime() >= 0 && this.f_19797_ > this.getLifetime()) {
            this.returnManaToCaster();
        }
        super.m_8119_();
    }

    private void returnManaToCaster() {
        Entity entity;
        if (this.mana <= 0 || !((entity = this.m_19749_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_7500_() && EBAccessoriesIntegration.isEquipped(player, EBItems.RING_MANA_RETURN.get())) {
            InventoryUtil.getHotBarAndOffhand(player).stream().filter(st -> st.m_41720_() instanceof IManaStoringItem).findAny().ifPresent(st -> ((IManaStoringItem)st.m_41720_()).rechargeMana((ItemStack)st, this.mana));
        }
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return EBSounds.ENTITY_FORCE_ARROW_HIT.get();
    }

    @Override
    public void tickInGround() {
        this.returnManaToCaster();
        this.m_146870_();
    }

    @Override
    public double getDamage() {
        return Spells.FORCE_ARROW.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return 20;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/force_arrow.png");
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.FORCE;
    }
}

