/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ForceOrbEntity
extends BombEntity {
    public ForceOrbEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ForceOrbEntity(Level level) {
        super(EBEntities.FORCE_ORB.get(), level);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            this.handleEntityHit();
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.handleServerHit();
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.handleServerHit();
        }
    }

    public void m_7822_(byte b) {
        if (b != 3) {
            return;
        }
        for (int j = 0; j < 20; ++j) {
            float brightness = 0.5f + this.f_19796_.m_188501_() / 2.0f;
            ParticleBuilder.create(EBParticles.SPARKLE, this.f_19796_, this.f_19854_, this.f_19855_, this.f_19856_, 0.25, true).time(6).color(brightness, 1.0f, brightness + 0.2f).spawn(this.m_9236_());
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_19854_, this.f_19855_, this.f_19856_, 0.0, 0.0, 0.0);
    }

    private void handleEntityHit() {
        this.m_5496_(EBSounds.ENTITY_FORCE_ORB_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    private void handleServerHit() {
        float pitch = this.f_19796_.m_188501_() * 0.2f + 0.3f;
        this.m_5496_(EBSounds.ENTITY_FORCE_ORB_HIT_BLOCK.get(), 1.5f, pitch);
        this.m_5496_(EBSounds.ENTITY_FORCE_ORB_HIT_BLOCK.get(), 1.5f, pitch - 0.01f);
        double blastRadius = Spells.FORCE_ORB.property(DefaultProperties.BLAST_RADIUS).floatValue() * this.blastMultiplier;
        List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(blastRadius, this.f_19854_, this.f_19855_, this.f_19856_, this.m_9236_());
        targets.stream().filter(target -> target != this.m_19749_()).forEach(target -> {
            double velY = target.m_20184_().f_82480_;
            double dx = this.f_19854_ - target.f_19854_ > 0.0 ? -0.5 - (this.f_19854_ - target.f_19854_) / 8.0 : 0.5 - (this.f_19854_ - target.f_19854_) / 8.0;
            double dz = this.f_19856_ - target.f_19856_ > 0.0 ? -0.5 - (this.f_19856_ - target.f_19856_) / 8.0 : 0.5 - (this.f_19856_ - target.f_19856_) / 8.0;
            float damage = Spells.FORCE_ORB.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            target.m_6469_(MagicDamageSource.causeIndirectMagicDamage((Entity)this, this.m_19749_(), EBDamageSources.BLAST), damage);
            target.m_20334_(dx, velY + 0.4, dz);
        });
        this.m_146870_();
    }

    @NotNull
    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }
}

