/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class IceBall
extends MagicProjectileEntity {
    public IceBall(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public IceBall(Level world) {
        super(EBEntities.ICE_BALL.get(), world);
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42452_;
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        if (!this.m_9236_().m_5776_()) {
            Entity entity = entityHitResult.m_82443_();
            float damage = Spells.ICE_BALL.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.FROST);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_BALL.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_BALL.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
            }
        }
        this.m_5496_(EBSounds.ENTITY_ICEBALL_HIT.get(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.3f);
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        if (blockHitResult.m_82434_() == Direction.UP && !this.m_9236_().m_5776_() && this.m_9236_().m_8055_(pos).m_60783_((BlockGetter)this.m_9236_(), pos, Direction.UP) && BlockUtil.canBlockBeReplaced(this.m_9236_(), pos.m_7494_()) && BlockUtil.canPlaceBlock((LivingEntity)this.m_19749_(), this.m_9236_(), pos)) {
            this.m_9236_().m_7731_(pos.m_7494_(), Blocks.f_50125_.m_49966_(), 3);
        }
        this.m_5496_(EBSounds.ENTITY_ICEBALL_HIT.get(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.3f);
        this.m_146870_();
        super.m_8060_(blockHitResult);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ > 3) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    public void m_7822_(byte status) {
        if (status == 3) {
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create(EBParticles.SNOW, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_, this.f_19856_, 0.4, false).scale(2.0f).time(8 + this.f_19796_.m_188503_(4)).spawn(this.m_9236_());
            }
        }
        super.m_7822_(status);
    }

    @Override
    public int getLifeTime() {
        return 16;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }
}

