/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.entity.projectile.IceShardEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class IceChargeEntity
extends BombEntity {
    public static final SpellProperty<Integer> ICE_SHARDS = SpellProperty.intProperty("ice_shards");

    public IceChargeEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public IceChargeEntity(Level world) {
        super(EBEntities.ICE_CHARGE.get(), world);
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        Entity entity;
        super.m_6532_(hitResult);
        Entity entity2 = entity = hitResult.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)hitResult).m_82443_() : null;
        if (entity != null) {
            float damage = Spells.ICE_CHARGE.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.FROST);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_) {
                    livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
                }
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
            return;
        }
        this.m_5496_(EBSounds.ENTITY_ICE_CHARGE_SMASH.get(), 1.5f, this.f_19796_.m_188501_() * 0.4f + 0.6f);
        this.m_5496_(EBSounds.ENTITY_ICE_CHARGE_ICE.get(), 1.2f, this.f_19796_.m_188501_() * 0.4f + 1.2f);
        double radius = 3.0f * this.blastMultiplier;
        List<LivingEntity> targets = EntityUtil.getLivingEntitiesInRange(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), radius);
        for (LivingEntity target : targets) {
            if (target == entity || target == this.m_19749_() || this.m_9236_().f_46443_) continue;
            target.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_CHARGE.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        }
        this.freezeNearbyBlocks();
        for (int i = 0; i < Spells.ICE_CHARGE.property(ICE_SHARDS); ++i) {
            double dx = this.f_19796_.m_188500_() - 0.5;
            double dy = this.f_19796_.m_188500_() - 0.5;
            double dz = this.f_19796_.m_188500_() - 0.5;
            IceShardEntity iceShard = new IceShardEntity(this.m_9236_());
            iceShard.m_6034_(this.m_20185_() + dx, this.m_20186_() + dy, this.m_20189_() + dz);
            iceShard.m_20334_(dx * 1.5, dy * 1.5, dz * 1.5);
            this.m_9236_().m_7967_((Entity)iceShard);
        }
        this.m_146870_();
    }

    private void freezeNearbyBlocks() {
        Level level = this.m_9236_();
        BlockPos basePos = BlockPos.m_274446_((Position)this.m_20182_());
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                double dist;
                BlockPos pos = basePos.m_7918_(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(level, pos, Direction.UP, 7, true, BlockUtil.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                if (y == null || this.f_19796_.m_188503_((int)(dist = this.m_20275_((pos = new BlockPos(pos.m_123341_(), y.intValue(), pos.m_123343_())).m_123341_(), pos.m_123342_(), pos.m_123343_())) * 2 + 1) >= 1 || !(dist < 2.0)) continue;
                BlockState belowState = level.m_8055_(pos.m_7495_());
                level.m_7731_(pos, belowState.m_60734_() == Blocks.f_49990_ ? Blocks.f_50126_.m_49966_() : Blocks.f_50125_.m_49966_(), 3);
            }
        }
    }

    private void spawnParticles() {
        Level level = this.m_9236_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        int i = 0;
        while ((float)i < 30.0f * this.blastMultiplier) {
            ParticleBuilder.create(EBParticles.ICE, level.m_213780_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f * this.blastMultiplier, false).time(35).gravity(true).spawn(level);
            float brightness = 0.4f + level.m_213780_().m_188501_() * 0.5f;
            ParticleBuilder.create(EBParticles.DARK_MAGIC, level.m_213780_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f * this.blastMultiplier, false).color(brightness, brightness + 0.1f, 1.0f).spawn(level);
            ++i;
        }
    }

    @NotNull
    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }
}

