/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class IceLanceEntity
extends MagicArrowEntity {
    public IceLanceEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public IceLanceEntity(Level world) {
        super(EBEntities.ICE_LANCE.get(), world);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.m_9236_().f_46443_) {
                livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_LANCE.property(DefaultProperties.EFFECT_DURATION).intValue(), 0));
            }
        }
        this.m_5496_(EBSounds.ENTITY_ICE_LANCE_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        super.m_5790_(hitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        if (this.m_9236_().m_5776_()) {
            for (int j = 0; j < 10; ++j) {
                ParticleBuilder.create(EBParticles.ICE, this.m_9236_().m_213780_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.5, true).time(20 + this.f_19796_.m_188503_(10)).gravity(true).spawn(this.m_9236_());
            }
        }
        this.m_5496_(EBSounds.ENTITY_ICE_LANCE_SMASH.get(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 1.2f);
        super.m_8060_(blockHitResult);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public double getDamage() {
        return Spells.ICE_LANCE.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/ice_lance.png");
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.FROST;
    }
}

