/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceShardEntity
extends MagicArrowEntity {
    public IceShardEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public IceShardEntity(Level world) {
        super(EBEntities.ICE_SHARD.get(), world);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        LivingEntity livingEntity;
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity && !MagicDamageSource.isEntityImmune(EBDamageSources.FROST, (Entity)(livingEntity = (LivingEntity)entity)) && !this.m_9236_().f_46443_) {
            livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), Spells.ICE_SHARD.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.ICE_SHARD.property(DefaultProperties.EFFECT_STRENGTH).intValue(), false, false));
        }
        this.m_5496_(EBSounds.ENTITY_ICE_SHARD_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        super.m_5790_(hitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        if (this.m_9236_().m_5776_()) {
            Vec3 pos = blockHitResult.m_82450_();
            ParticleBuilder.create(EBParticles.FLASH).pos(pos).color(0.75f, 1.0f, 1.0f).spawn(this.m_9236_());
            for (int i = 0; i < 8; ++i) {
                ParticleBuilder.create(EBParticles.ICE, this.f_19796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.5, true).time(20 + this.f_19796_.m_188503_(10)).gravity(true).spawn(this.m_9236_());
            }
        }
        this.m_5496_(EBSounds.ENTITY_ICE_SHARD_SMASH.get(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 1.2f);
        super.m_8060_(blockHitResult);
    }

    @Override
    public void tickInGround() {
        if (this.ticksInGround > 40) {
            this.m_146870_();
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public double getDamage() {
        return Spells.ICE_SHARD.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/ice_shard.png");
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.FROST;
    }
}

