/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class LightningArrow
extends MagicArrowEntity {
    public LightningArrow(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public LightningArrow(Level world) {
        super(EBEntities.LIGHTNING_ARROW.get(), world);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        for (int i = 0; i < 8; ++i) {
            if (!this.m_9236_().m_5776_()) continue;
            ParticleBuilder.create(EBParticles.SPARK, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_ + (double)(this.m_20206_() / 2.0f), this.f_19856_, 1.0, false).spawn(this.m_9236_());
        }
        this.m_5496_(EBSounds.ENTITY_LIGHTNING_ARROW_HIT.get(), 1.0f, 1.0f);
        super.m_5790_(hitResult);
    }

    @Override
    public void ticksInAir() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        ParticleBuilder.create(EBParticles.SPARK).pos(this.f_19854_, this.f_19855_, this.f_19856_).spawn(this.m_9236_());
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public double getDamage() {
        return Spells.LIGHTNING_ARROW.property(DefaultProperties.DAMAGE).floatValue();
    }

    @Override
    public int getLifetime() {
        return 20;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/lightning_arrow.png");
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.SHOCK;
    }
}

