/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MagicMissileEntity
extends MagicArrowEntity {
    public MagicMissileEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public MagicMissileEntity(Level world) {
        super(EBEntities.MAGIC_MISSILE.get(), world);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        this.m_5496_(EBSounds.ENTITY_MAGIC_MISSILE_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        if (this.m_9236_().m_5776_()) {
            ParticleBuilder.create(EBParticles.FLASH).pos(this.f_19854_, this.f_19855_, this.f_19856_).color(1.0f, 1.0f, 0.65f).spawn(this.m_9236_());
        }
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        Vec3 vec = blockHitResult.m_82450_();
        if (this.m_9236_().f_46443_) {
            ParticleBuilder.create(EBParticles.FLASH).pos(vec).color(1.0f, 1.0f, 0.65f).fade(0.85f, 0.5f, 0.8f).spawn(this.m_9236_());
        }
    }

    @Override
    public void ticksInAir() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        double x = this.m_20185_() - this.m_20184_().f_82479_ / 2.0;
        double y = this.m_20186_() - this.m_20184_().f_82480_ / 2.0;
        double z = this.m_20189_() - this.m_20184_().f_82481_ / 2.0;
        if (WizardryMainMod.IS_THE_SEASON) {
            ParticleBuilder.create(EBParticles.SPARKLE, this.f_19796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.03, true).color(0.8f, 0.15f, 0.15f).time(20 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
            ParticleBuilder.create(EBParticles.SNOW).pos(this.m_20185_(), this.m_20186_(), this.m_20189_()).spawn(this.m_9236_());
            if (this.f_19797_ > 1) {
                ParticleBuilder.create(EBParticles.SPARKLE, this.f_19796_, x, y, z, 0.03, true).color(0.15f, 0.7f, 0.15f).time(20 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
            }
        } else {
            ParticleBuilder.create(EBParticles.SPARKLE, this.f_19796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.03, true).color(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).time(20 + this.f_19796_.m_188503_(10)).spawn(this.m_9236_());
            if (this.f_19797_ > 1) {
                ParticleBuilder.create(EBParticles.SPARKLE, this.m_9236_().m_213780_(), x, y, z, 0.03, true).color(1.0f, 1.0f, 0.65f).time(20 + this.f_19796_.m_188503_(10)).fade(0.7f, 0.0f, 1.0f).spawn(this.m_9236_());
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Override
    public double getDamage() {
        return Spells.MAGIC_MISSILE.property(DefaultProperties.DAMAGE).floatValue();
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public int getLifetime() {
        return 12;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("ebwizardry", "textures/entity/magic_missile.png");
    }
}

