/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class PoisonBombEntity
extends BombEntity {
    public PoisonBombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public PoisonBombEntity(LivingEntity livingEntity, Level world) {
        super(EBEntities.POISON_BOMB.get(), livingEntity, world);
    }

    public PoisonBombEntity(Level world) {
        super(EBEntities.POISON_BOMB.get(), world);
    }

    @NotNull
    protected Item m_7881_() {
        return EBItems.POISON_BOMB.get();
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        float damage = Spells.POISON_BOMB.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity entity = entityHitResult.m_82443_();
            MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.POISON);
        }
        if (hitResult instanceof BlockHitResult) {
            double range = Spells.POISON_BOMB.property(DefaultProperties.EFFECT_RADIUS).intValue();
            List<LivingEntity> livingEntities = EntityUtil.getLivingEntitiesInRange(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), range);
            for (LivingEntity entity : livingEntities) {
                if (entity == null || entity == this.m_19749_()) continue;
                MagicDamageSource.causeMagicDamage((Entity)this, (Entity)entity, damage, EBDamageSources.FIRE);
                if (MagicDamageSource.isEntityImmune(EBDamageSources.POISON, (Entity)entity)) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, Spells.POISON_BOMB.property(DefaultProperties.EFFECT_DURATION).intValue(), Spells.POISON_BOMB.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
            }
        }
        this.m_5496_(EBSounds.ENTITY_POISON_BOMB_SMASH.get(), 1.5f, this.f_19796_.m_188501_() * 0.4f + 0.6f);
        this.m_5496_(EBSounds.ENTITY_POISON_BOMB_POISON.get(), 1.2f, 1.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)3);
        this.m_146870_();
    }

    public void m_7822_(byte status) {
        if (status == 3) {
            int i = 0;
            while ((float)i < 60.0f * this.blastMultiplier) {
                ParticleBuilder.create(EBParticles.SPARKLE, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_, this.f_19856_, 2.0f * this.blastMultiplier).scale(2.0f).color(0.2f + this.f_19796_.m_188501_() * 0.3f, 0.6f, 0.0f).time(35).spawn(this.m_9236_());
                ParticleBuilder.create(EBParticles.DARK_MAGIC, this.m_9236_().m_213780_(), this.f_19854_, this.f_19855_, this.f_19856_, 2.0f * this.blastMultiplier, false).color(0.2f + this.f_19796_.m_188501_() * 0.2f, 0.8f, 0.0f).spawn(this.m_9236_());
                ++i;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_19854_, this.f_19855_, this.f_19856_, 0.0, 0.0, 0.0);
        }
        super.m_7822_(status);
    }
}

