/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class SparkBombEntity
extends BombEntity {
    public SparkBombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public SparkBombEntity(Level world) {
        super(EBEntities.SPARK_BOMB.get(), world);
    }

    public SparkBombEntity(LivingEntity livingEntity, Level world) {
        super(EBEntities.SPARK_BOMB.get(), livingEntity, world);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.m_5496_(EBSounds.ENTITY_SPARK_BOMB_HIT_BLOCK.get(), 0.5f, 0.5f);
        super.m_8060_(blockHitResult);
        LivingEntity closestEntity = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(3.0));
        if (closestEntity != null) {
            MagicDamageSource.causeMagicDamage((Entity)this, (Entity)closestEntity, 4.0f, EBDamageSources.SHOCK);
        }
        ParticleBuilder.spawnShockParticles(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
    }

    protected void m_5790_(EntityHitResult result) {
        float damage = 6.0f;
        MagicDamageSource.causeMagicDamage((Entity)this, result.m_82443_(), damage, EBDamageSources.SHOCK);
        this.m_5496_(EBSounds.ENTITY_SPARK_BOMB_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        ParticleBuilder.create(EBParticles.LIGHTNING).pos(this.m_20182_()).target(result.m_82443_()).spawn(this.m_9236_());
        ParticleBuilder.spawnShockParticles(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        super.m_5790_(result);
    }

    public int m_20094_() {
        return -1;
    }

    @NotNull
    protected Item m_7881_() {
        return EBItems.SPARK_BOMB.get();
    }
}

