/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.entity.projectile;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class SparkEntity
extends MagicProjectileEntity {
    public SparkEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public SparkEntity(Level world) {
        super(EBEntities.SPARK.get(), world);
    }

    protected void m_6532_(HitResult hitResult) {
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            float damage = Spells.HOMING_SPARK.property(DefaultProperties.DAMAGE).floatValue() * this.damageMultiplier;
            Entity entity = entityHitResult.m_82443_();
            MagicDamageSource.causeMagicDamage((Entity)this, entity, damage, EBDamageSources.SHOCK);
        }
        this.m_5496_(EBSounds.ENTITY_HOMING_SPARK_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 8; ++i) {
                double x = this.f_19854_ + this.f_19796_.m_188500_() - 0.5;
                double y = this.f_19855_ + (double)(this.m_20206_() / 2.0f) + this.f_19796_.m_188500_() - 0.5;
                double z = this.f_19856_ + this.f_19796_.m_188500_() - 0.5;
                ParticleBuilder.create(EBParticles.SPARK).pos(x, y, z).spawn(this.m_9236_());
            }
        }
        super.m_6532_(hitResult);
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    public int getLifeTime() {
        return 50;
    }

    @NotNull
    protected Item m_7881_() {
        return ItemStack.f_41583_.m_41720_();
    }

    @Override
    public float getSeekingStrength() {
        return Spells.HOMING_SPARK.property(DefaultProperties.SEEKING_STRENGTH).intValue();
    }
}

